package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lakeformation.model.primitives.CatalogIdString
import scala.jdk.CollectionConverters._
final case class BatchGrantPermissionsRequest(
    catalogId: Option[CatalogIdString] = None,
    entries: Iterable[zio.aws.lakeformation.model.BatchPermissionsRequestEntry]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.BatchGrantPermissionsRequest = {
    import BatchGrantPermissionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.BatchGrantPermissionsRequest
      .builder()
      .optionallyWith(
        catalogId.map(value => CatalogIdString.unwrap(value): java.lang.String)
      )(_.catalogId)
      .entries(entries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.BatchGrantPermissionsRequest.ReadOnly =
    zio.aws.lakeformation.model.BatchGrantPermissionsRequest
      .wrap(buildAwsValue())
}
object BatchGrantPermissionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.BatchGrantPermissionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.BatchGrantPermissionsRequest =
      zio.aws.lakeformation.model.BatchGrantPermissionsRequest(
        catalogId.map(value => value),
        entries.map { item =>
          item.asEditable
        }
      )
    def catalogId: Option[CatalogIdString]
    def entries: List[
      zio.aws.lakeformation.model.BatchPermissionsRequestEntry.ReadOnly
    ]
    def getCatalogId: ZIO[Any, AwsError, CatalogIdString] =
      AwsError.unwrapOptionField("catalogId", catalogId)
    def getEntries: ZIO[Any, Nothing, List[
      zio.aws.lakeformation.model.BatchPermissionsRequestEntry.ReadOnly
    ]] = ZIO.succeed(entries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.BatchGrantPermissionsRequest
  ) extends zio.aws.lakeformation.model.BatchGrantPermissionsRequest.ReadOnly {
    override val catalogId: Option[CatalogIdString] = scala
      .Option(impl.catalogId())
      .map(value =>
        zio.aws.lakeformation.model.primitives.CatalogIdString(value)
      )
    override val entries: List[
      zio.aws.lakeformation.model.BatchPermissionsRequestEntry.ReadOnly
    ] = impl
      .entries()
      .asScala
      .map { item =>
        zio.aws.lakeformation.model.BatchPermissionsRequestEntry.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.BatchGrantPermissionsRequest
  ): zio.aws.lakeformation.model.BatchGrantPermissionsRequest.ReadOnly =
    new Wrapper(impl)
}
