package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lakeformation.model.primitives.CatalogIdString
import scala.jdk.CollectionConverters._
final case class AddLfTagsToResourceRequest(
    catalogId: Option[CatalogIdString] = None,
    resource: zio.aws.lakeformation.model.Resource,
    lfTags: Iterable[zio.aws.lakeformation.model.LFTagPair]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.AddLfTagsToResourceRequest = {
    import AddLfTagsToResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.AddLfTagsToResourceRequest
      .builder()
      .optionallyWith(
        catalogId.map(value => CatalogIdString.unwrap(value): java.lang.String)
      )(_.catalogId)
      .resource(resource.buildAwsValue())
      .lfTags(lfTags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.AddLfTagsToResourceRequest.ReadOnly =
    zio.aws.lakeformation.model.AddLfTagsToResourceRequest.wrap(buildAwsValue())
}
object AddLfTagsToResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.AddLfTagsToResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.AddLfTagsToResourceRequest =
      zio.aws.lakeformation.model.AddLfTagsToResourceRequest(
        catalogId.map(value => value),
        resource.asEditable,
        lfTags.map { item =>
          item.asEditable
        }
      )
    def catalogId: Option[CatalogIdString]
    def resource: zio.aws.lakeformation.model.Resource.ReadOnly
    def lfTags: List[zio.aws.lakeformation.model.LFTagPair.ReadOnly]
    def getCatalogId: ZIO[Any, AwsError, CatalogIdString] =
      AwsError.unwrapOptionField("catalogId", catalogId)
    def getResource
        : ZIO[Any, Nothing, zio.aws.lakeformation.model.Resource.ReadOnly] =
      ZIO.succeed(resource)
    def getLfTags: ZIO[Any, Nothing, List[
      zio.aws.lakeformation.model.LFTagPair.ReadOnly
    ]] = ZIO.succeed(lfTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.AddLfTagsToResourceRequest
  ) extends zio.aws.lakeformation.model.AddLfTagsToResourceRequest.ReadOnly {
    override val catalogId: Option[CatalogIdString] = scala
      .Option(impl.catalogId())
      .map(value =>
        zio.aws.lakeformation.model.primitives.CatalogIdString(value)
      )
    override val resource: zio.aws.lakeformation.model.Resource.ReadOnly =
      zio.aws.lakeformation.model.Resource.wrap(impl.resource())
    override val lfTags: List[zio.aws.lakeformation.model.LFTagPair.ReadOnly] =
      impl
        .lfTags()
        .asScala
        .map { item =>
          zio.aws.lakeformation.model.LFTagPair.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.AddLfTagsToResourceRequest
  ): zio.aws.lakeformation.model.AddLfTagsToResourceRequest.ReadOnly =
    new Wrapper(impl)
}
