package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lakeformation.model.primitives.{NameString, CatalogIdString}
import scala.jdk.CollectionConverters._
final case class TableWithColumnsResource(
    catalogId: Option[CatalogIdString] = None,
    databaseName: NameString,
    name: NameString,
    columnNames: Option[Iterable[NameString]] = None,
    columnWildcard: Option[zio.aws.lakeformation.model.ColumnWildcard] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.TableWithColumnsResource = {
    import TableWithColumnsResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.TableWithColumnsResource
      .builder()
      .optionallyWith(
        catalogId.map(value => CatalogIdString.unwrap(value): java.lang.String)
      )(_.catalogId)
      .databaseName(NameString.unwrap(databaseName): java.lang.String)
      .name(NameString.unwrap(name): java.lang.String)
      .optionallyWith(
        columnNames.map(value =>
          value.map { item =>
            NameString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.columnNames)
      .optionallyWith(columnWildcard.map(value => value.buildAwsValue()))(
        _.columnWildcard
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.TableWithColumnsResource.ReadOnly =
    zio.aws.lakeformation.model.TableWithColumnsResource.wrap(buildAwsValue())
}
object TableWithColumnsResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.TableWithColumnsResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.TableWithColumnsResource =
      zio.aws.lakeformation.model.TableWithColumnsResource(
        catalogId.map(value => value),
        databaseName,
        name,
        columnNames.map(value => value),
        columnWildcard.map(value => value.asEditable)
      )
    def catalogId: Option[CatalogIdString]
    def databaseName: NameString
    def name: NameString
    def columnNames: Option[List[NameString]]
    def columnWildcard
        : Option[zio.aws.lakeformation.model.ColumnWildcard.ReadOnly]
    def getCatalogId: ZIO[Any, AwsError, CatalogIdString] =
      AwsError.unwrapOptionField("catalogId", catalogId)
    def getDatabaseName: ZIO[Any, Nothing, NameString] =
      ZIO.succeed(databaseName)
    def getName: ZIO[Any, Nothing, NameString] = ZIO.succeed(name)
    def getColumnNames: ZIO[Any, AwsError, List[NameString]] =
      AwsError.unwrapOptionField("columnNames", columnNames)
    def getColumnWildcard: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.ColumnWildcard.ReadOnly
    ] = AwsError.unwrapOptionField("columnWildcard", columnWildcard)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.TableWithColumnsResource
  ) extends zio.aws.lakeformation.model.TableWithColumnsResource.ReadOnly {
    override val catalogId: Option[CatalogIdString] = scala
      .Option(impl.catalogId())
      .map(value =>
        zio.aws.lakeformation.model.primitives.CatalogIdString(value)
      )
    override val databaseName: NameString =
      zio.aws.lakeformation.model.primitives.NameString(impl.databaseName())
    override val name: NameString =
      zio.aws.lakeformation.model.primitives.NameString(impl.name())
    override val columnNames: Option[List[NameString]] = scala
      .Option(impl.columnNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lakeformation.model.primitives.NameString(item)
        }.toList
      )
    override val columnWildcard
        : Option[zio.aws.lakeformation.model.ColumnWildcard.ReadOnly] = scala
      .Option(impl.columnWildcard())
      .map(value => zio.aws.lakeformation.model.ColumnWildcard.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.TableWithColumnsResource
  ): zio.aws.lakeformation.model.TableWithColumnsResource.ReadOnly =
    new Wrapper(impl)
}
