package zio.aws.lakeformation.model
import scala.jdk.CollectionConverters._
sealed trait QueryStateString {
  def unwrap
      : software.amazon.awssdk.services.lakeformation.model.QueryStateString
}
object QueryStateString {
  def wrap(
      value: software.amazon.awssdk.services.lakeformation.model.QueryStateString
  ): zio.aws.lakeformation.model.QueryStateString = value match {
    case software.amazon.awssdk.services.lakeformation.model.QueryStateString.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lakeformation.model.QueryStateString.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.lakeformation.model.QueryStateString.WORKUNITS_AVAILABLE =>
      val r = WORKUNITS_AVAILABLE
      r
    case software.amazon.awssdk.services.lakeformation.model.QueryStateString.ERROR =>
      val r = ERROR
      r
    case software.amazon.awssdk.services.lakeformation.model.QueryStateString.FINISHED =>
      val r = FINISHED
      r
    case software.amazon.awssdk.services.lakeformation.model.QueryStateString.EXPIRED =>
      val r = EXPIRED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lakeformation.model.QueryStateString {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.QueryStateString =
      software.amazon.awssdk.services.lakeformation.model.QueryStateString.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.lakeformation.model.QueryStateString {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.QueryStateString =
      software.amazon.awssdk.services.lakeformation.model.QueryStateString.PENDING
  }
  case object WORKUNITS_AVAILABLE
      extends zio.aws.lakeformation.model.QueryStateString {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.QueryStateString =
      software.amazon.awssdk.services.lakeformation.model.QueryStateString.WORKUNITS_AVAILABLE
  }
  case object ERROR extends zio.aws.lakeformation.model.QueryStateString {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.QueryStateString =
      software.amazon.awssdk.services.lakeformation.model.QueryStateString.ERROR
  }
  case object FINISHED extends zio.aws.lakeformation.model.QueryStateString {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.QueryStateString =
      software.amazon.awssdk.services.lakeformation.model.QueryStateString.FINISHED
  }
  case object EXPIRED extends zio.aws.lakeformation.model.QueryStateString {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.QueryStateString =
      software.amazon.awssdk.services.lakeformation.model.QueryStateString.EXPIRED
  }
}
