package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lakeformation.model.primitives.{
  LFTagValue,
  LFTagKey,
  CatalogIdString
}
import scala.jdk.CollectionConverters._
final case class LFTagPair(
    catalogId: Option[CatalogIdString] = None,
    tagKey: LFTagKey,
    tagValues: Iterable[LFTagValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.LFTagPair = {
    import LFTagPair.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.LFTagPair
      .builder()
      .optionallyWith(
        catalogId.map(value => CatalogIdString.unwrap(value): java.lang.String)
      )(_.catalogId)
      .tagKey(LFTagKey.unwrap(tagKey): java.lang.String)
      .tagValues(tagValues.map { item =>
        LFTagValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.LFTagPair.ReadOnly =
    zio.aws.lakeformation.model.LFTagPair.wrap(buildAwsValue())
}
object LFTagPair {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.LFTagPair
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.LFTagPair =
      zio.aws.lakeformation.model
        .LFTagPair(catalogId.map(value => value), tagKey, tagValues)
    def catalogId: Option[CatalogIdString]
    def tagKey: LFTagKey
    def tagValues: List[LFTagValue]
    def getCatalogId: ZIO[Any, AwsError, CatalogIdString] =
      AwsError.unwrapOptionField("catalogId", catalogId)
    def getTagKey: ZIO[Any, Nothing, LFTagKey] = ZIO.succeed(tagKey)
    def getTagValues: ZIO[Any, Nothing, List[LFTagValue]] =
      ZIO.succeed(tagValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.LFTagPair
  ) extends zio.aws.lakeformation.model.LFTagPair.ReadOnly {
    override val catalogId: Option[CatalogIdString] = scala
      .Option(impl.catalogId())
      .map(value =>
        zio.aws.lakeformation.model.primitives.CatalogIdString(value)
      )
    override val tagKey: LFTagKey =
      zio.aws.lakeformation.model.primitives.LFTagKey(impl.tagKey())
    override val tagValues: List[LFTagValue] = impl
      .tagValues()
      .asScala
      .map { item =>
        zio.aws.lakeformation.model.primitives.LFTagValue(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.LFTagPair
  ): zio.aws.lakeformation.model.LFTagPair.ReadOnly = new Wrapper(impl)
}
