package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.lakeformation.model.primitives.GetQueryStateRequestQueryIdString
import scala.jdk.CollectionConverters._
final case class GetQueryStateRequest(
    queryId: GetQueryStateRequestQueryIdString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.GetQueryStateRequest = {
    import GetQueryStateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.GetQueryStateRequest
      .builder()
      .queryId(
        GetQueryStateRequestQueryIdString.unwrap(queryId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.GetQueryStateRequest.ReadOnly =
    zio.aws.lakeformation.model.GetQueryStateRequest.wrap(buildAwsValue())
}
object GetQueryStateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.GetQueryStateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.GetQueryStateRequest =
      zio.aws.lakeformation.model.GetQueryStateRequest(queryId)
    def queryId: GetQueryStateRequestQueryIdString
    def getQueryId: ZIO[Any, Nothing, GetQueryStateRequestQueryIdString] =
      ZIO.succeed(queryId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.GetQueryStateRequest
  ) extends zio.aws.lakeformation.model.GetQueryStateRequest.ReadOnly {
    override val queryId: GetQueryStateRequestQueryIdString =
      zio.aws.lakeformation.model.primitives
        .GetQueryStateRequestQueryIdString(impl.queryId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.GetQueryStateRequest
  ): zio.aws.lakeformation.model.GetQueryStateRequest.ReadOnly = new Wrapper(
    impl
  )
}
