package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.lakeformation.model.primitives.TransactionIdString
import scala.jdk.CollectionConverters._
final case class DescribeTransactionRequest(
    transactionId: TransactionIdString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.DescribeTransactionRequest = {
    import DescribeTransactionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.DescribeTransactionRequest
      .builder()
      .transactionId(
        TransactionIdString.unwrap(transactionId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.DescribeTransactionRequest.ReadOnly =
    zio.aws.lakeformation.model.DescribeTransactionRequest.wrap(buildAwsValue())
}
object DescribeTransactionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.DescribeTransactionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.DescribeTransactionRequest =
      zio.aws.lakeformation.model.DescribeTransactionRequest(transactionId)
    def transactionId: TransactionIdString
    def getTransactionId: ZIO[Any, Nothing, TransactionIdString] =
      ZIO.succeed(transactionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.DescribeTransactionRequest
  ) extends zio.aws.lakeformation.model.DescribeTransactionRequest.ReadOnly {
    override val transactionId: TransactionIdString =
      zio.aws.lakeformation.model.primitives
        .TransactionIdString(impl.transactionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.DescribeTransactionRequest
  ): zio.aws.lakeformation.model.DescribeTransactionRequest.ReadOnly =
    new Wrapper(impl)
}
