package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BatchGrantPermissionsResponse(
    failures: Option[
      Iterable[zio.aws.lakeformation.model.BatchPermissionsFailureEntry]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.BatchGrantPermissionsResponse = {
    import BatchGrantPermissionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.BatchGrantPermissionsResponse
      .builder()
      .optionallyWith(
        failures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failures)
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.BatchGrantPermissionsResponse.ReadOnly =
    zio.aws.lakeformation.model.BatchGrantPermissionsResponse
      .wrap(buildAwsValue())
}
object BatchGrantPermissionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.BatchGrantPermissionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.BatchGrantPermissionsResponse =
      zio.aws.lakeformation.model.BatchGrantPermissionsResponse(
        failures.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def failures: Option[
      List[zio.aws.lakeformation.model.BatchPermissionsFailureEntry.ReadOnly]
    ]
    def getFailures: ZIO[Any, AwsError, List[
      zio.aws.lakeformation.model.BatchPermissionsFailureEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("failures", failures)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.BatchGrantPermissionsResponse
  ) extends zio.aws.lakeformation.model.BatchGrantPermissionsResponse.ReadOnly {
    override val failures: Option[
      List[zio.aws.lakeformation.model.BatchPermissionsFailureEntry.ReadOnly]
    ] = scala
      .Option(impl.failures())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lakeformation.model.BatchPermissionsFailureEntry.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.BatchGrantPermissionsResponse
  ): zio.aws.lakeformation.model.BatchGrantPermissionsResponse.ReadOnly =
    new Wrapper(impl)
}
