package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.lakeformation.model.primitives.{
  LastModifiedTimestamp,
  IAMRoleArn,
  ResourceArnString
}
import scala.jdk.CollectionConverters._
final case class ResourceInfo(
    resourceArn: Option[ResourceArnString] = None,
    roleArn: Option[IAMRoleArn] = None,
    lastModified: Option[LastModifiedTimestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.ResourceInfo = {
    import ResourceInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.ResourceInfo
      .builder()
      .optionallyWith(
        resourceArn.map(value =>
          ResourceArnString.unwrap(value): java.lang.String
        )
      )(_.resourceArn)
      .optionallyWith(
        roleArn.map(value => IAMRoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        lastModified.map(value => LastModifiedTimestamp.unwrap(value): Instant)
      )(_.lastModified)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.ResourceInfo.ReadOnly =
    zio.aws.lakeformation.model.ResourceInfo.wrap(buildAwsValue())
}
object ResourceInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.ResourceInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.ResourceInfo =
      zio.aws.lakeformation.model.ResourceInfo(
        resourceArn.map(value => value),
        roleArn.map(value => value),
        lastModified.map(value => value)
      )
    def resourceArn: Option[ResourceArnString]
    def roleArn: Option[IAMRoleArn]
    def lastModified: Option[LastModifiedTimestamp]
    def getResourceArn: ZIO[Any, AwsError, ResourceArnString] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getRoleArn: ZIO[Any, AwsError, IAMRoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getLastModified: ZIO[Any, AwsError, LastModifiedTimestamp] =
      AwsError.unwrapOptionField("lastModified", lastModified)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.ResourceInfo
  ) extends zio.aws.lakeformation.model.ResourceInfo.ReadOnly {
    override val resourceArn: Option[ResourceArnString] = scala
      .Option(impl.resourceArn())
      .map(value =>
        zio.aws.lakeformation.model.primitives.ResourceArnString(value)
      )
    override val roleArn: Option[IAMRoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.lakeformation.model.primitives.IAMRoleArn(value))
    override val lastModified: Option[LastModifiedTimestamp] = scala
      .Option(impl.lastModified())
      .map(value =>
        zio.aws.lakeformation.model.primitives.LastModifiedTimestamp(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.ResourceInfo
  ): zio.aws.lakeformation.model.ResourceInfo.ReadOnly = new Wrapper(impl)
}
