package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Resource(
    catalog: Option[zio.aws.lakeformation.model.CatalogResource] = None,
    database: Option[zio.aws.lakeformation.model.DatabaseResource] = None,
    table: Option[zio.aws.lakeformation.model.TableResource] = None,
    tableWithColumns: Option[
      zio.aws.lakeformation.model.TableWithColumnsResource
    ] = None,
    dataLocation: Option[zio.aws.lakeformation.model.DataLocationResource] =
      None,
    dataCellsFilter: Option[
      zio.aws.lakeformation.model.DataCellsFilterResource
    ] = None,
    lfTag: Option[zio.aws.lakeformation.model.LFTagKeyResource] = None,
    lfTagPolicy: Option[zio.aws.lakeformation.model.LFTagPolicyResource] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.Resource = {
    import Resource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.Resource
      .builder()
      .optionallyWith(catalog.map(value => value.buildAwsValue()))(_.catalog)
      .optionallyWith(database.map(value => value.buildAwsValue()))(_.database)
      .optionallyWith(table.map(value => value.buildAwsValue()))(_.table)
      .optionallyWith(tableWithColumns.map(value => value.buildAwsValue()))(
        _.tableWithColumns
      )
      .optionallyWith(dataLocation.map(value => value.buildAwsValue()))(
        _.dataLocation
      )
      .optionallyWith(dataCellsFilter.map(value => value.buildAwsValue()))(
        _.dataCellsFilter
      )
      .optionallyWith(lfTag.map(value => value.buildAwsValue()))(_.lfTag)
      .optionallyWith(lfTagPolicy.map(value => value.buildAwsValue()))(
        _.lfTagPolicy
      )
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.Resource.ReadOnly =
    zio.aws.lakeformation.model.Resource.wrap(buildAwsValue())
}
object Resource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.Resource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.Resource =
      zio.aws.lakeformation.model.Resource(
        catalog.map(value => value.asEditable),
        database.map(value => value.asEditable),
        table.map(value => value.asEditable),
        tableWithColumns.map(value => value.asEditable),
        dataLocation.map(value => value.asEditable),
        dataCellsFilter.map(value => value.asEditable),
        lfTag.map(value => value.asEditable),
        lfTagPolicy.map(value => value.asEditable)
      )
    def catalog: Option[zio.aws.lakeformation.model.CatalogResource.ReadOnly]
    def database: Option[zio.aws.lakeformation.model.DatabaseResource.ReadOnly]
    def table: Option[zio.aws.lakeformation.model.TableResource.ReadOnly]
    def tableWithColumns
        : Option[zio.aws.lakeformation.model.TableWithColumnsResource.ReadOnly]
    def dataLocation
        : Option[zio.aws.lakeformation.model.DataLocationResource.ReadOnly]
    def dataCellsFilter
        : Option[zio.aws.lakeformation.model.DataCellsFilterResource.ReadOnly]
    def lfTag: Option[zio.aws.lakeformation.model.LFTagKeyResource.ReadOnly]
    def lfTagPolicy
        : Option[zio.aws.lakeformation.model.LFTagPolicyResource.ReadOnly]
    def getCatalog: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.CatalogResource.ReadOnly
    ] = AwsError.unwrapOptionField("catalog", catalog)
    def getDatabase: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.DatabaseResource.ReadOnly
    ] = AwsError.unwrapOptionField("database", database)
    def getTable: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.TableResource.ReadOnly
    ] = AwsError.unwrapOptionField("table", table)
    def getTableWithColumns: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.TableWithColumnsResource.ReadOnly
    ] = AwsError.unwrapOptionField("tableWithColumns", tableWithColumns)
    def getDataLocation: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.DataLocationResource.ReadOnly
    ] = AwsError.unwrapOptionField("dataLocation", dataLocation)
    def getDataCellsFilter: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.DataCellsFilterResource.ReadOnly
    ] = AwsError.unwrapOptionField("dataCellsFilter", dataCellsFilter)
    def getLfTag: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.LFTagKeyResource.ReadOnly
    ] = AwsError.unwrapOptionField("lfTag", lfTag)
    def getLfTagPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.LFTagPolicyResource.ReadOnly
    ] = AwsError.unwrapOptionField("lfTagPolicy", lfTagPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.Resource
  ) extends zio.aws.lakeformation.model.Resource.ReadOnly {
    override val catalog
        : Option[zio.aws.lakeformation.model.CatalogResource.ReadOnly] = scala
      .Option(impl.catalog())
      .map(value => zio.aws.lakeformation.model.CatalogResource.wrap(value))
    override val database
        : Option[zio.aws.lakeformation.model.DatabaseResource.ReadOnly] = scala
      .Option(impl.database())
      .map(value => zio.aws.lakeformation.model.DatabaseResource.wrap(value))
    override val table
        : Option[zio.aws.lakeformation.model.TableResource.ReadOnly] = scala
      .Option(impl.table())
      .map(value => zio.aws.lakeformation.model.TableResource.wrap(value))
    override val tableWithColumns: Option[
      zio.aws.lakeformation.model.TableWithColumnsResource.ReadOnly
    ] = scala
      .Option(impl.tableWithColumns())
      .map(value =>
        zio.aws.lakeformation.model.TableWithColumnsResource.wrap(value)
      )
    override val dataLocation
        : Option[zio.aws.lakeformation.model.DataLocationResource.ReadOnly] =
      scala
        .Option(impl.dataLocation())
        .map(value =>
          zio.aws.lakeformation.model.DataLocationResource.wrap(value)
        )
    override val dataCellsFilter
        : Option[zio.aws.lakeformation.model.DataCellsFilterResource.ReadOnly] =
      scala
        .Option(impl.dataCellsFilter())
        .map(value =>
          zio.aws.lakeformation.model.DataCellsFilterResource.wrap(value)
        )
    override val lfTag
        : Option[zio.aws.lakeformation.model.LFTagKeyResource.ReadOnly] = scala
      .Option(impl.lfTag())
      .map(value => zio.aws.lakeformation.model.LFTagKeyResource.wrap(value))
    override val lfTagPolicy
        : Option[zio.aws.lakeformation.model.LFTagPolicyResource.ReadOnly] =
      scala
        .Option(impl.lfTagPolicy())
        .map(value =>
          zio.aws.lakeformation.model.LFTagPolicyResource.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.Resource
  ): zio.aws.lakeformation.model.Resource.ReadOnly = new Wrapper(impl)
}
