package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.lakeformation.model.primitives.DateTime
import scala.jdk.CollectionConverters._
final case class GetQueryStatisticsResponse(
    executionStatistics: Option[
      zio.aws.lakeformation.model.ExecutionStatistics
    ] = None,
    planningStatistics: Option[zio.aws.lakeformation.model.PlanningStatistics] =
      None,
    querySubmissionTime: Option[DateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.GetQueryStatisticsResponse = {
    import GetQueryStatisticsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.GetQueryStatisticsResponse
      .builder()
      .optionallyWith(executionStatistics.map(value => value.buildAwsValue()))(
        _.executionStatistics
      )
      .optionallyWith(planningStatistics.map(value => value.buildAwsValue()))(
        _.planningStatistics
      )
      .optionallyWith(
        querySubmissionTime.map(value => DateTime.unwrap(value): Instant)
      )(_.querySubmissionTime)
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.GetQueryStatisticsResponse.ReadOnly =
    zio.aws.lakeformation.model.GetQueryStatisticsResponse.wrap(buildAwsValue())
}
object GetQueryStatisticsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.GetQueryStatisticsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.GetQueryStatisticsResponse =
      zio.aws.lakeformation.model.GetQueryStatisticsResponse(
        executionStatistics.map(value => value.asEditable),
        planningStatistics.map(value => value.asEditable),
        querySubmissionTime.map(value => value)
      )
    def executionStatistics
        : Option[zio.aws.lakeformation.model.ExecutionStatistics.ReadOnly]
    def planningStatistics
        : Option[zio.aws.lakeformation.model.PlanningStatistics.ReadOnly]
    def querySubmissionTime: Option[DateTime]
    def getExecutionStatistics: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.ExecutionStatistics.ReadOnly
    ] = AwsError.unwrapOptionField("executionStatistics", executionStatistics)
    def getPlanningStatistics: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.PlanningStatistics.ReadOnly
    ] = AwsError.unwrapOptionField("planningStatistics", planningStatistics)
    def getQuerySubmissionTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("querySubmissionTime", querySubmissionTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.GetQueryStatisticsResponse
  ) extends zio.aws.lakeformation.model.GetQueryStatisticsResponse.ReadOnly {
    override val executionStatistics
        : Option[zio.aws.lakeformation.model.ExecutionStatistics.ReadOnly] =
      scala
        .Option(impl.executionStatistics())
        .map(value =>
          zio.aws.lakeformation.model.ExecutionStatistics.wrap(value)
        )
    override val planningStatistics
        : Option[zio.aws.lakeformation.model.PlanningStatistics.ReadOnly] =
      scala
        .Option(impl.planningStatistics())
        .map(value =>
          zio.aws.lakeformation.model.PlanningStatistics.wrap(value)
        )
    override val querySubmissionTime: Option[DateTime] = scala
      .Option(impl.querySubmissionTime())
      .map(value => zio.aws.lakeformation.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.GetQueryStatisticsResponse
  ): zio.aws.lakeformation.model.GetQueryStatisticsResponse.ReadOnly =
    new Wrapper(impl)
}
