package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lakeformation.model.primitives.{
  NumberOfItems,
  NumberOfBytes,
  NumberOfMilliseconds
}
import scala.jdk.CollectionConverters._
final case class ExecutionStatistics(
    averageExecutionTimeMillis: Option[NumberOfMilliseconds] = None,
    dataScannedBytes: Option[NumberOfBytes] = None,
    workUnitsExecutedCount: Option[NumberOfItems] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.ExecutionStatistics = {
    import ExecutionStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.ExecutionStatistics
      .builder()
      .optionallyWith(
        averageExecutionTimeMillis.map(value =>
          NumberOfMilliseconds.unwrap(value): java.lang.Long
        )
      )(_.averageExecutionTimeMillis)
      .optionallyWith(
        dataScannedBytes.map(value =>
          NumberOfBytes.unwrap(value): java.lang.Long
        )
      )(_.dataScannedBytes)
      .optionallyWith(
        workUnitsExecutedCount.map(value =>
          NumberOfItems.unwrap(value): java.lang.Long
        )
      )(_.workUnitsExecutedCount)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.ExecutionStatistics.ReadOnly =
    zio.aws.lakeformation.model.ExecutionStatistics.wrap(buildAwsValue())
}
object ExecutionStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.ExecutionStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.ExecutionStatistics =
      zio.aws.lakeformation.model.ExecutionStatistics(
        averageExecutionTimeMillis.map(value => value),
        dataScannedBytes.map(value => value),
        workUnitsExecutedCount.map(value => value)
      )
    def averageExecutionTimeMillis: Option[NumberOfMilliseconds]
    def dataScannedBytes: Option[NumberOfBytes]
    def workUnitsExecutedCount: Option[NumberOfItems]
    def getAverageExecutionTimeMillis
        : ZIO[Any, AwsError, NumberOfMilliseconds] = AwsError.unwrapOptionField(
      "averageExecutionTimeMillis",
      averageExecutionTimeMillis
    )
    def getDataScannedBytes: ZIO[Any, AwsError, NumberOfBytes] =
      AwsError.unwrapOptionField("dataScannedBytes", dataScannedBytes)
    def getWorkUnitsExecutedCount: ZIO[Any, AwsError, NumberOfItems] = AwsError
      .unwrapOptionField("workUnitsExecutedCount", workUnitsExecutedCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.ExecutionStatistics
  ) extends zio.aws.lakeformation.model.ExecutionStatistics.ReadOnly {
    override val averageExecutionTimeMillis: Option[NumberOfMilliseconds] =
      scala
        .Option(impl.averageExecutionTimeMillis())
        .map(value =>
          zio.aws.lakeformation.model.primitives.NumberOfMilliseconds(value)
        )
    override val dataScannedBytes: Option[NumberOfBytes] = scala
      .Option(impl.dataScannedBytes())
      .map(value => zio.aws.lakeformation.model.primitives.NumberOfBytes(value))
    override val workUnitsExecutedCount: Option[NumberOfItems] = scala
      .Option(impl.workUnitsExecutedCount())
      .map(value => zio.aws.lakeformation.model.primitives.NumberOfItems(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.ExecutionStatistics
  ): zio.aws.lakeformation.model.ExecutionStatistics.ReadOnly = new Wrapper(
    impl
  )
}
