package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lakeformation.model.primitives.PredicateString
import scala.jdk.CollectionConverters._
final case class RowFilter(
    filterExpression: Option[PredicateString] = None,
    allRowsWildcard: Option[zio.aws.lakeformation.model.AllRowsWildcard] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.RowFilter = {
    import RowFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.RowFilter
      .builder()
      .optionallyWith(
        filterExpression.map(value =>
          PredicateString.unwrap(value): java.lang.String
        )
      )(_.filterExpression)
      .optionallyWith(allRowsWildcard.map(value => value.buildAwsValue()))(
        _.allRowsWildcard
      )
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.RowFilter.ReadOnly =
    zio.aws.lakeformation.model.RowFilter.wrap(buildAwsValue())
}
object RowFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.RowFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.RowFilter =
      zio.aws.lakeformation.model.RowFilter(
        filterExpression.map(value => value),
        allRowsWildcard.map(value => value.asEditable)
      )
    def filterExpression: Option[PredicateString]
    def allRowsWildcard
        : Option[zio.aws.lakeformation.model.AllRowsWildcard.ReadOnly]
    def getFilterExpression: ZIO[Any, AwsError, PredicateString] =
      AwsError.unwrapOptionField("filterExpression", filterExpression)
    def getAllRowsWildcard: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.AllRowsWildcard.ReadOnly
    ] = AwsError.unwrapOptionField("allRowsWildcard", allRowsWildcard)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.RowFilter
  ) extends zio.aws.lakeformation.model.RowFilter.ReadOnly {
    override val filterExpression: Option[PredicateString] = scala
      .Option(impl.filterExpression())
      .map(value =>
        zio.aws.lakeformation.model.primitives.PredicateString(value)
      )
    override val allRowsWildcard
        : Option[zio.aws.lakeformation.model.AllRowsWildcard.ReadOnly] = scala
      .Option(impl.allRowsWildcard())
      .map(value => zio.aws.lakeformation.model.AllRowsWildcard.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.RowFilter
  ): zio.aws.lakeformation.model.RowFilter.ReadOnly = new Wrapper(impl)
}
