package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lakeformation.model.primitives.{
  LFTagValue,
  NameString,
  CatalogIdString
}
import scala.jdk.CollectionConverters._
final case class LFTagKeyResource(
    catalogId: Option[CatalogIdString] = None,
    tagKey: NameString,
    tagValues: Iterable[LFTagValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.LFTagKeyResource = {
    import LFTagKeyResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.LFTagKeyResource
      .builder()
      .optionallyWith(
        catalogId.map(value => CatalogIdString.unwrap(value): java.lang.String)
      )(_.catalogId)
      .tagKey(NameString.unwrap(tagKey): java.lang.String)
      .tagValues(tagValues.map { item =>
        LFTagValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.LFTagKeyResource.ReadOnly =
    zio.aws.lakeformation.model.LFTagKeyResource.wrap(buildAwsValue())
}
object LFTagKeyResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.LFTagKeyResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.LFTagKeyResource =
      zio.aws.lakeformation.model
        .LFTagKeyResource(catalogId.map(value => value), tagKey, tagValues)
    def catalogId: Option[CatalogIdString]
    def tagKey: NameString
    def tagValues: List[LFTagValue]
    def getCatalogId: ZIO[Any, AwsError, CatalogIdString] =
      AwsError.unwrapOptionField("catalogId", catalogId)
    def getTagKey: ZIO[Any, Nothing, NameString] = ZIO.succeed(tagKey)
    def getTagValues: ZIO[Any, Nothing, List[LFTagValue]] =
      ZIO.succeed(tagValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.LFTagKeyResource
  ) extends zio.aws.lakeformation.model.LFTagKeyResource.ReadOnly {
    override val catalogId: Option[CatalogIdString] = scala
      .Option(impl.catalogId())
      .map(value =>
        zio.aws.lakeformation.model.primitives.CatalogIdString(value)
      )
    override val tagKey: NameString =
      zio.aws.lakeformation.model.primitives.NameString(impl.tagKey())
    override val tagValues: List[LFTagValue] = impl
      .tagValues()
      .asScala
      .map { item =>
        zio.aws.lakeformation.model.primitives.LFTagValue(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.LFTagKeyResource
  ): zio.aws.lakeformation.model.LFTagKeyResource.ReadOnly = new Wrapper(impl)
}
