package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lakeformation.model.primitives.CatalogIdString
import scala.jdk.CollectionConverters._
final case class GetDataLakeSettingsRequest(
    catalogId: Option[CatalogIdString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.GetDataLakeSettingsRequest = {
    import GetDataLakeSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.GetDataLakeSettingsRequest
      .builder()
      .optionallyWith(
        catalogId.map(value => CatalogIdString.unwrap(value): java.lang.String)
      )(_.catalogId)
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.GetDataLakeSettingsRequest.ReadOnly =
    zio.aws.lakeformation.model.GetDataLakeSettingsRequest.wrap(buildAwsValue())
}
object GetDataLakeSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.GetDataLakeSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.GetDataLakeSettingsRequest =
      zio.aws.lakeformation.model
        .GetDataLakeSettingsRequest(catalogId.map(value => value))
    def catalogId: Option[CatalogIdString]
    def getCatalogId: ZIO[Any, AwsError, CatalogIdString] =
      AwsError.unwrapOptionField("catalogId", catalogId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.GetDataLakeSettingsRequest
  ) extends zio.aws.lakeformation.model.GetDataLakeSettingsRequest.ReadOnly {
    override val catalogId: Option[CatalogIdString] = scala
      .Option(impl.catalogId())
      .map(value =>
        zio.aws.lakeformation.model.primitives.CatalogIdString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.GetDataLakeSettingsRequest
  ): zio.aws.lakeformation.model.GetDataLakeSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
