package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeTransactionResponse(
    transactionDescription: Option[
      zio.aws.lakeformation.model.TransactionDescription
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.DescribeTransactionResponse = {
    import DescribeTransactionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.DescribeTransactionResponse
      .builder()
      .optionallyWith(
        transactionDescription.map(value => value.buildAwsValue())
      )(_.transactionDescription)
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.DescribeTransactionResponse.ReadOnly =
    zio.aws.lakeformation.model.DescribeTransactionResponse
      .wrap(buildAwsValue())
}
object DescribeTransactionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.DescribeTransactionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.DescribeTransactionResponse =
      zio.aws.lakeformation.model.DescribeTransactionResponse(
        transactionDescription.map(value => value.asEditable)
      )
    def transactionDescription
        : Option[zio.aws.lakeformation.model.TransactionDescription.ReadOnly]
    def getTransactionDescription: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.TransactionDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "transactionDescription",
      transactionDescription
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.DescribeTransactionResponse
  ) extends zio.aws.lakeformation.model.DescribeTransactionResponse.ReadOnly {
    override val transactionDescription
        : Option[zio.aws.lakeformation.model.TransactionDescription.ReadOnly] =
      scala
        .Option(impl.transactionDescription())
        .map(value =>
          zio.aws.lakeformation.model.TransactionDescription.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.DescribeTransactionResponse
  ): zio.aws.lakeformation.model.DescribeTransactionResponse.ReadOnly =
    new Wrapper(impl)
}
