package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lakeformation.model.primitives.{
  TransactionIdString,
  NameString,
  CatalogIdString
}
import scala.jdk.CollectionConverters._
final case class UpdateTableObjectsRequest(
    catalogId: Option[CatalogIdString] = None,
    databaseName: NameString,
    tableName: NameString,
    transactionId: TransactionIdString,
    writeOperations: Iterable[zio.aws.lakeformation.model.WriteOperation]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.UpdateTableObjectsRequest = {
    import UpdateTableObjectsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.UpdateTableObjectsRequest
      .builder()
      .optionallyWith(
        catalogId.map(value => CatalogIdString.unwrap(value): java.lang.String)
      )(_.catalogId)
      .databaseName(NameString.unwrap(databaseName): java.lang.String)
      .tableName(NameString.unwrap(tableName): java.lang.String)
      .transactionId(
        TransactionIdString.unwrap(transactionId): java.lang.String
      )
      .writeOperations(writeOperations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.UpdateTableObjectsRequest.ReadOnly =
    zio.aws.lakeformation.model.UpdateTableObjectsRequest.wrap(buildAwsValue())
}
object UpdateTableObjectsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.UpdateTableObjectsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.UpdateTableObjectsRequest =
      zio.aws.lakeformation.model.UpdateTableObjectsRequest(
        catalogId.map(value => value),
        databaseName,
        tableName,
        transactionId,
        writeOperations.map { item =>
          item.asEditable
        }
      )
    def catalogId: Option[CatalogIdString]
    def databaseName: NameString
    def tableName: NameString
    def transactionId: TransactionIdString
    def writeOperations
        : List[zio.aws.lakeformation.model.WriteOperation.ReadOnly]
    def getCatalogId: ZIO[Any, AwsError, CatalogIdString] =
      AwsError.unwrapOptionField("catalogId", catalogId)
    def getDatabaseName: ZIO[Any, Nothing, NameString] =
      ZIO.succeed(databaseName)
    def getTableName: ZIO[Any, Nothing, NameString] = ZIO.succeed(tableName)
    def getTransactionId: ZIO[Any, Nothing, TransactionIdString] =
      ZIO.succeed(transactionId)
    def getWriteOperations: ZIO[Any, Nothing, List[
      zio.aws.lakeformation.model.WriteOperation.ReadOnly
    ]] = ZIO.succeed(writeOperations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.UpdateTableObjectsRequest
  ) extends zio.aws.lakeformation.model.UpdateTableObjectsRequest.ReadOnly {
    override val catalogId: Option[CatalogIdString] = scala
      .Option(impl.catalogId())
      .map(value =>
        zio.aws.lakeformation.model.primitives.CatalogIdString(value)
      )
    override val databaseName: NameString =
      zio.aws.lakeformation.model.primitives.NameString(impl.databaseName())
    override val tableName: NameString =
      zio.aws.lakeformation.model.primitives.NameString(impl.tableName())
    override val transactionId: TransactionIdString =
      zio.aws.lakeformation.model.primitives
        .TransactionIdString(impl.transactionId())
    override val writeOperations
        : List[zio.aws.lakeformation.model.WriteOperation.ReadOnly] = impl
      .writeOperations()
      .asScala
      .map { item =>
        zio.aws.lakeformation.model.WriteOperation.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.UpdateTableObjectsRequest
  ): zio.aws.lakeformation.model.UpdateTableObjectsRequest.ReadOnly =
    new Wrapper(impl)
}
