package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.lakeformation.model.primitives.ValueString
import scala.jdk.CollectionConverters._
final case class PartitionValueList(values: Iterable[ValueString]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.PartitionValueList = {
    import PartitionValueList.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.PartitionValueList
      .builder()
      .values(values.map { item =>
        ValueString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.PartitionValueList.ReadOnly =
    zio.aws.lakeformation.model.PartitionValueList.wrap(buildAwsValue())
}
object PartitionValueList {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.PartitionValueList
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.PartitionValueList =
      zio.aws.lakeformation.model.PartitionValueList(values)
    def values: List[ValueString]
    def getValues: ZIO[Any, Nothing, List[ValueString]] = ZIO.succeed(values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.PartitionValueList
  ) extends zio.aws.lakeformation.model.PartitionValueList.ReadOnly {
    override val values: List[ValueString] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.lakeformation.model.primitives.ValueString(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.PartitionValueList
  ): zio.aws.lakeformation.model.PartitionValueList.ReadOnly = new Wrapper(impl)
}
