package zio.aws.lakeformation.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lakeformation.model.primitives.{
  TokenString,
  PageSize,
  CatalogIdString
}
import scala.jdk.CollectionConverters._
final case class ListTransactionsRequest(
    catalogId: Option[CatalogIdString] = None,
    statusFilter: Option[zio.aws.lakeformation.model.TransactionStatusFilter] =
      None,
    maxResults: Option[PageSize] = None,
    nextToken: Option[TokenString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.ListTransactionsRequest = {
    import ListTransactionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.ListTransactionsRequest
      .builder()
      .optionallyWith(
        catalogId.map(value => CatalogIdString.unwrap(value): java.lang.String)
      )(_.catalogId)
      .optionallyWith(statusFilter.map(value => value.unwrap))(_.statusFilter)
      .optionallyWith(maxResults.map(value => PageSize.unwrap(value): Integer))(
        _.maxResults
      )
      .optionallyWith(
        nextToken.map(value => TokenString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.ListTransactionsRequest.ReadOnly =
    zio.aws.lakeformation.model.ListTransactionsRequest.wrap(buildAwsValue())
}
object ListTransactionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.ListTransactionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.ListTransactionsRequest =
      zio.aws.lakeformation.model.ListTransactionsRequest(
        catalogId.map(value => value),
        statusFilter.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def catalogId: Option[CatalogIdString]
    def statusFilter
        : Option[zio.aws.lakeformation.model.TransactionStatusFilter]
    def maxResults: Option[PageSize]
    def nextToken: Option[TokenString]
    def getCatalogId: ZIO[Any, AwsError, CatalogIdString] =
      AwsError.unwrapOptionField("catalogId", catalogId)
    def getStatusFilter: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.TransactionStatusFilter
    ] = AwsError.unwrapOptionField("statusFilter", statusFilter)
    def getMaxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, TokenString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.ListTransactionsRequest
  ) extends zio.aws.lakeformation.model.ListTransactionsRequest.ReadOnly {
    override val catalogId: Option[CatalogIdString] = scala
      .Option(impl.catalogId())
      .map(value =>
        zio.aws.lakeformation.model.primitives.CatalogIdString(value)
      )
    override val statusFilter
        : Option[zio.aws.lakeformation.model.TransactionStatusFilter] = scala
      .Option(impl.statusFilter())
      .map(value =>
        zio.aws.lakeformation.model.TransactionStatusFilter.wrap(value)
      )
    override val maxResults: Option[PageSize] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.lakeformation.model.primitives.PageSize(value))
    override val nextToken: Option[TokenString] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.lakeformation.model.primitives.TokenString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.ListTransactionsRequest
  ): zio.aws.lakeformation.model.ListTransactionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
