package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lakeformation.model.primitives.Token
import scala.jdk.CollectionConverters._
final case class ListLfTagsResponse(
    lfTags: Option[Iterable[zio.aws.lakeformation.model.LFTagPair]] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.ListLfTagsResponse = {
    import ListLfTagsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.ListLfTagsResponse
      .builder()
      .optionallyWith(
        lfTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lfTags)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.ListLfTagsResponse.ReadOnly =
    zio.aws.lakeformation.model.ListLfTagsResponse.wrap(buildAwsValue())
}
object ListLfTagsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.ListLfTagsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.ListLfTagsResponse =
      zio.aws.lakeformation.model.ListLfTagsResponse(
        lfTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def lfTags: Option[List[zio.aws.lakeformation.model.LFTagPair.ReadOnly]]
    def nextToken: Option[Token]
    def getLfTags: ZIO[Any, AwsError, List[
      zio.aws.lakeformation.model.LFTagPair.ReadOnly
    ]] = AwsError.unwrapOptionField("lfTags", lfTags)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.ListLfTagsResponse
  ) extends zio.aws.lakeformation.model.ListLfTagsResponse.ReadOnly {
    override val lfTags
        : Option[List[zio.aws.lakeformation.model.LFTagPair.ReadOnly]] = scala
      .Option(impl.lfTags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lakeformation.model.LFTagPair.wrap(item)
        }.toList
      )
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.lakeformation.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.ListLfTagsResponse
  ): zio.aws.lakeformation.model.ListLfTagsResponse.ReadOnly = new Wrapper(impl)
}
