package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.lakeformation.model.primitives.{
  ExpirationTimestamp,
  SessionTokenString,
  SecretAccessKeyString,
  AccessKeyIdString
}
import scala.jdk.CollectionConverters._
final case class GetTemporaryGluePartitionCredentialsResponse(
    accessKeyId: Option[AccessKeyIdString] = None,
    secretAccessKey: Option[SecretAccessKeyString] = None,
    sessionToken: Option[SessionTokenString] = None,
    expiration: Option[ExpirationTimestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.GetTemporaryGluePartitionCredentialsResponse = {
    import GetTemporaryGluePartitionCredentialsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.GetTemporaryGluePartitionCredentialsResponse
      .builder()
      .optionallyWith(
        accessKeyId.map(value =>
          AccessKeyIdString.unwrap(value): java.lang.String
        )
      )(_.accessKeyId)
      .optionallyWith(
        secretAccessKey.map(value =>
          SecretAccessKeyString.unwrap(value): java.lang.String
        )
      )(_.secretAccessKey)
      .optionallyWith(
        sessionToken.map(value =>
          SessionTokenString.unwrap(value): java.lang.String
        )
      )(_.sessionToken)
      .optionallyWith(
        expiration.map(value => ExpirationTimestamp.unwrap(value): Instant)
      )(_.expiration)
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.GetTemporaryGluePartitionCredentialsResponse.ReadOnly =
    zio.aws.lakeformation.model.GetTemporaryGluePartitionCredentialsResponse
      .wrap(buildAwsValue())
}
object GetTemporaryGluePartitionCredentialsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.GetTemporaryGluePartitionCredentialsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lakeformation.model.GetTemporaryGluePartitionCredentialsResponse =
      zio.aws.lakeformation.model.GetTemporaryGluePartitionCredentialsResponse(
        accessKeyId.map(value => value),
        secretAccessKey.map(value => value),
        sessionToken.map(value => value),
        expiration.map(value => value)
      )
    def accessKeyId: Option[AccessKeyIdString]
    def secretAccessKey: Option[SecretAccessKeyString]
    def sessionToken: Option[SessionTokenString]
    def expiration: Option[ExpirationTimestamp]
    def getAccessKeyId: ZIO[Any, AwsError, AccessKeyIdString] =
      AwsError.unwrapOptionField("accessKeyId", accessKeyId)
    def getSecretAccessKey: ZIO[Any, AwsError, SecretAccessKeyString] =
      AwsError.unwrapOptionField("secretAccessKey", secretAccessKey)
    def getSessionToken: ZIO[Any, AwsError, SessionTokenString] =
      AwsError.unwrapOptionField("sessionToken", sessionToken)
    def getExpiration: ZIO[Any, AwsError, ExpirationTimestamp] =
      AwsError.unwrapOptionField("expiration", expiration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.GetTemporaryGluePartitionCredentialsResponse
  ) extends zio.aws.lakeformation.model.GetTemporaryGluePartitionCredentialsResponse.ReadOnly {
    override val accessKeyId: Option[AccessKeyIdString] = scala
      .Option(impl.accessKeyId())
      .map(value =>
        zio.aws.lakeformation.model.primitives.AccessKeyIdString(value)
      )
    override val secretAccessKey: Option[SecretAccessKeyString] = scala
      .Option(impl.secretAccessKey())
      .map(value =>
        zio.aws.lakeformation.model.primitives.SecretAccessKeyString(value)
      )
    override val sessionToken: Option[SessionTokenString] = scala
      .Option(impl.sessionToken())
      .map(value =>
        zio.aws.lakeformation.model.primitives.SessionTokenString(value)
      )
    override val expiration: Option[ExpirationTimestamp] = scala
      .Option(impl.expiration())
      .map(value =>
        zio.aws.lakeformation.model.primitives.ExpirationTimestamp(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.GetTemporaryGluePartitionCredentialsResponse
  ): zio.aws.lakeformation.model.GetTemporaryGluePartitionCredentialsResponse.ReadOnly =
    new Wrapper(impl)
}
