package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lakeformation.model.primitives.{ObjectSize, ETagString, URI}
import scala.jdk.CollectionConverters._
final case class TableObject(
    uri: Option[URI] = None,
    eTag: Option[ETagString] = None,
    size: Option[ObjectSize] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.TableObject = {
    import TableObject.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.TableObject
      .builder()
      .optionallyWith(uri.map(value => URI.unwrap(value): java.lang.String))(
        _.uri
      )
      .optionallyWith(
        eTag.map(value => ETagString.unwrap(value): java.lang.String)
      )(_.eTag)
      .optionallyWith(
        size.map(value => ObjectSize.unwrap(value): java.lang.Long)
      )(_.size)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.TableObject.ReadOnly =
    zio.aws.lakeformation.model.TableObject.wrap(buildAwsValue())
}
object TableObject {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.TableObject
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.TableObject =
      zio.aws.lakeformation.model.TableObject(
        uri.map(value => value),
        eTag.map(value => value),
        size.map(value => value)
      )
    def uri: Option[URI]
    def eTag: Option[ETagString]
    def size: Option[ObjectSize]
    def getUri: ZIO[Any, AwsError, URI] = AwsError.unwrapOptionField("uri", uri)
    def getETag: ZIO[Any, AwsError, ETagString] =
      AwsError.unwrapOptionField("eTag", eTag)
    def getSize: ZIO[Any, AwsError, ObjectSize] =
      AwsError.unwrapOptionField("size", size)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.TableObject
  ) extends zio.aws.lakeformation.model.TableObject.ReadOnly {
    override val uri: Option[URI] = scala
      .Option(impl.uri())
      .map(value => zio.aws.lakeformation.model.primitives.URI(value))
    override val eTag: Option[ETagString] = scala
      .Option(impl.eTag())
      .map(value => zio.aws.lakeformation.model.primitives.ETagString(value))
    override val size: Option[ObjectSize] = scala
      .Option(impl.size())
      .map(value => zio.aws.lakeformation.model.primitives.ObjectSize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.TableObject
  ): zio.aws.lakeformation.model.TableObject.ReadOnly = new Wrapper(impl)
}
