package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lakeformation.model.primitives.{
  NumberOfItems,
  NumberOfMilliseconds,
  NumberOfBytes
}
import scala.jdk.CollectionConverters._
final case class PlanningStatistics(
    estimatedDataToScanBytes: Option[NumberOfBytes] = None,
    planningTimeMillis: Option[NumberOfMilliseconds] = None,
    queueTimeMillis: Option[NumberOfMilliseconds] = None,
    workUnitsGeneratedCount: Option[NumberOfItems] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.PlanningStatistics = {
    import PlanningStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.PlanningStatistics
      .builder()
      .optionallyWith(
        estimatedDataToScanBytes.map(value =>
          NumberOfBytes.unwrap(value): java.lang.Long
        )
      )(_.estimatedDataToScanBytes)
      .optionallyWith(
        planningTimeMillis.map(value =>
          NumberOfMilliseconds.unwrap(value): java.lang.Long
        )
      )(_.planningTimeMillis)
      .optionallyWith(
        queueTimeMillis.map(value =>
          NumberOfMilliseconds.unwrap(value): java.lang.Long
        )
      )(_.queueTimeMillis)
      .optionallyWith(
        workUnitsGeneratedCount.map(value =>
          NumberOfItems.unwrap(value): java.lang.Long
        )
      )(_.workUnitsGeneratedCount)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.PlanningStatistics.ReadOnly =
    zio.aws.lakeformation.model.PlanningStatistics.wrap(buildAwsValue())
}
object PlanningStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.PlanningStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.PlanningStatistics =
      zio.aws.lakeformation.model.PlanningStatistics(
        estimatedDataToScanBytes.map(value => value),
        planningTimeMillis.map(value => value),
        queueTimeMillis.map(value => value),
        workUnitsGeneratedCount.map(value => value)
      )
    def estimatedDataToScanBytes: Option[NumberOfBytes]
    def planningTimeMillis: Option[NumberOfMilliseconds]
    def queueTimeMillis: Option[NumberOfMilliseconds]
    def workUnitsGeneratedCount: Option[NumberOfItems]
    def getEstimatedDataToScanBytes: ZIO[Any, AwsError, NumberOfBytes] =
      AwsError.unwrapOptionField(
        "estimatedDataToScanBytes",
        estimatedDataToScanBytes
      )
    def getPlanningTimeMillis: ZIO[Any, AwsError, NumberOfMilliseconds] =
      AwsError.unwrapOptionField("planningTimeMillis", planningTimeMillis)
    def getQueueTimeMillis: ZIO[Any, AwsError, NumberOfMilliseconds] =
      AwsError.unwrapOptionField("queueTimeMillis", queueTimeMillis)
    def getWorkUnitsGeneratedCount: ZIO[Any, AwsError, NumberOfItems] = AwsError
      .unwrapOptionField("workUnitsGeneratedCount", workUnitsGeneratedCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.PlanningStatistics
  ) extends zio.aws.lakeformation.model.PlanningStatistics.ReadOnly {
    override val estimatedDataToScanBytes: Option[NumberOfBytes] = scala
      .Option(impl.estimatedDataToScanBytes())
      .map(value => zio.aws.lakeformation.model.primitives.NumberOfBytes(value))
    override val planningTimeMillis: Option[NumberOfMilliseconds] = scala
      .Option(impl.planningTimeMillis())
      .map(value =>
        zio.aws.lakeformation.model.primitives.NumberOfMilliseconds(value)
      )
    override val queueTimeMillis: Option[NumberOfMilliseconds] = scala
      .Option(impl.queueTimeMillis())
      .map(value =>
        zio.aws.lakeformation.model.primitives.NumberOfMilliseconds(value)
      )
    override val workUnitsGeneratedCount: Option[NumberOfItems] = scala
      .Option(impl.workUnitsGeneratedCount())
      .map(value => zio.aws.lakeformation.model.primitives.NumberOfItems(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.PlanningStatistics
  ): zio.aws.lakeformation.model.PlanningStatistics.ReadOnly = new Wrapper(impl)
}
