package zio.aws.lakeformation.model
import scala.jdk.CollectionConverters._
sealed trait OptimizerType {
  def unwrap: software.amazon.awssdk.services.lakeformation.model.OptimizerType
}
object OptimizerType {
  def wrap(
      value: software.amazon.awssdk.services.lakeformation.model.OptimizerType
  ): zio.aws.lakeformation.model.OptimizerType = value match {
    case software.amazon.awssdk.services.lakeformation.model.OptimizerType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lakeformation.model.OptimizerType.COMPACTION =>
      val r = COMPACTION
      r
    case software.amazon.awssdk.services.lakeformation.model.OptimizerType.GARBAGE_COLLECTION =>
      val r = GARBAGE_COLLECTION
      r
    case software.amazon.awssdk.services.lakeformation.model.OptimizerType.ALL =>
      val r = ALL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lakeformation.model.OptimizerType {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.OptimizerType =
      software.amazon.awssdk.services.lakeformation.model.OptimizerType.UNKNOWN_TO_SDK_VERSION
  }
  case object COMPACTION extends zio.aws.lakeformation.model.OptimizerType {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.OptimizerType =
      software.amazon.awssdk.services.lakeformation.model.OptimizerType.COMPACTION
  }
  case object GARBAGE_COLLECTION
      extends zio.aws.lakeformation.model.OptimizerType {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.OptimizerType =
      software.amazon.awssdk.services.lakeformation.model.OptimizerType.GARBAGE_COLLECTION
  }
  case object ALL extends zio.aws.lakeformation.model.OptimizerType {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.OptimizerType =
      software.amazon.awssdk.services.lakeformation.model.OptimizerType.ALL
  }
}
