package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lakeformation.model.primitives.Token
import scala.jdk.CollectionConverters._
final case class ListTableStorageOptimizersResponse(
    storageOptimizerList: Option[
      Iterable[zio.aws.lakeformation.model.StorageOptimizer]
    ] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.ListTableStorageOptimizersResponse = {
    import ListTableStorageOptimizersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.ListTableStorageOptimizersResponse
      .builder()
      .optionallyWith(
        storageOptimizerList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.storageOptimizerList)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.ListTableStorageOptimizersResponse.ReadOnly =
    zio.aws.lakeformation.model.ListTableStorageOptimizersResponse
      .wrap(buildAwsValue())
}
object ListTableStorageOptimizersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.ListTableStorageOptimizersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lakeformation.model.ListTableStorageOptimizersResponse =
      zio.aws.lakeformation.model.ListTableStorageOptimizersResponse(
        storageOptimizerList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def storageOptimizerList
        : Option[List[zio.aws.lakeformation.model.StorageOptimizer.ReadOnly]]
    def nextToken: Option[Token]
    def getStorageOptimizerList: ZIO[Any, AwsError, List[
      zio.aws.lakeformation.model.StorageOptimizer.ReadOnly
    ]] =
      AwsError.unwrapOptionField("storageOptimizerList", storageOptimizerList)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.ListTableStorageOptimizersResponse
  ) extends zio.aws.lakeformation.model.ListTableStorageOptimizersResponse.ReadOnly {
    override val storageOptimizerList
        : Option[List[zio.aws.lakeformation.model.StorageOptimizer.ReadOnly]] =
      scala
        .Option(impl.storageOptimizerList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lakeformation.model.StorageOptimizer.wrap(item)
          }.toList
        )
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.lakeformation.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.ListTableStorageOptimizersResponse
  ): zio.aws.lakeformation.model.ListTableStorageOptimizersResponse.ReadOnly =
    new Wrapper(impl)
}
