package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lakeformation.model.primitives.Token
import scala.jdk.CollectionConverters._
final case class ListResourcesResponse(
    resourceInfoList: Option[
      Iterable[zio.aws.lakeformation.model.ResourceInfo]
    ] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.ListResourcesResponse = {
    import ListResourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.ListResourcesResponse
      .builder()
      .optionallyWith(
        resourceInfoList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceInfoList)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.ListResourcesResponse.ReadOnly =
    zio.aws.lakeformation.model.ListResourcesResponse.wrap(buildAwsValue())
}
object ListResourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.ListResourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.ListResourcesResponse =
      zio.aws.lakeformation.model.ListResourcesResponse(
        resourceInfoList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def resourceInfoList
        : Option[List[zio.aws.lakeformation.model.ResourceInfo.ReadOnly]]
    def nextToken: Option[Token]
    def getResourceInfoList: ZIO[Any, AwsError, List[
      zio.aws.lakeformation.model.ResourceInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceInfoList", resourceInfoList)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.ListResourcesResponse
  ) extends zio.aws.lakeformation.model.ListResourcesResponse.ReadOnly {
    override val resourceInfoList
        : Option[List[zio.aws.lakeformation.model.ResourceInfo.ReadOnly]] =
      scala
        .Option(impl.resourceInfoList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lakeformation.model.ResourceInfo.wrap(item)
          }.toList
        )
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.lakeformation.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.ListResourcesResponse
  ): zio.aws.lakeformation.model.ListResourcesResponse.ReadOnly = new Wrapper(
    impl
  )
}
