package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lakeformation.model.primitives.{
  LFTagValue,
  LFTagKey,
  CatalogIdString
}
import scala.jdk.CollectionConverters._
final case class GetLfTagResponse(
    catalogId: Option[CatalogIdString] = None,
    tagKey: Option[LFTagKey] = None,
    tagValues: Option[Iterable[LFTagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.GetLfTagResponse = {
    import GetLfTagResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.GetLfTagResponse
      .builder()
      .optionallyWith(
        catalogId.map(value => CatalogIdString.unwrap(value): java.lang.String)
      )(_.catalogId)
      .optionallyWith(
        tagKey.map(value => LFTagKey.unwrap(value): java.lang.String)
      )(_.tagKey)
      .optionallyWith(
        tagValues.map(value =>
          value.map { item =>
            LFTagValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.tagValues)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.GetLfTagResponse.ReadOnly =
    zio.aws.lakeformation.model.GetLfTagResponse.wrap(buildAwsValue())
}
object GetLfTagResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.GetLfTagResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.GetLfTagResponse =
      zio.aws.lakeformation.model.GetLfTagResponse(
        catalogId.map(value => value),
        tagKey.map(value => value),
        tagValues.map(value => value)
      )
    def catalogId: Option[CatalogIdString]
    def tagKey: Option[LFTagKey]
    def tagValues: Option[List[LFTagValue]]
    def getCatalogId: ZIO[Any, AwsError, CatalogIdString] =
      AwsError.unwrapOptionField("catalogId", catalogId)
    def getTagKey: ZIO[Any, AwsError, LFTagKey] =
      AwsError.unwrapOptionField("tagKey", tagKey)
    def getTagValues: ZIO[Any, AwsError, List[LFTagValue]] =
      AwsError.unwrapOptionField("tagValues", tagValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.GetLfTagResponse
  ) extends zio.aws.lakeformation.model.GetLfTagResponse.ReadOnly {
    override val catalogId: Option[CatalogIdString] = scala
      .Option(impl.catalogId())
      .map(value =>
        zio.aws.lakeformation.model.primitives.CatalogIdString(value)
      )
    override val tagKey: Option[LFTagKey] = scala
      .Option(impl.tagKey())
      .map(value => zio.aws.lakeformation.model.primitives.LFTagKey(value))
    override val tagValues: Option[List[LFTagValue]] = scala
      .Option(impl.tagValues())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lakeformation.model.primitives.LFTagValue(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.GetLfTagResponse
  ): zio.aws.lakeformation.model.GetLfTagResponse.ReadOnly = new Wrapper(impl)
}
