package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lakeformation.model.primitives.RAMResourceShareArn
import scala.jdk.CollectionConverters._
final case class DetailsMap(
    resourceShare: Option[Iterable[RAMResourceShareArn]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.DetailsMap = {
    import DetailsMap.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.DetailsMap
      .builder()
      .optionallyWith(
        resourceShare.map(value =>
          value.map { item =>
            RAMResourceShareArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.resourceShare)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.DetailsMap.ReadOnly =
    zio.aws.lakeformation.model.DetailsMap.wrap(buildAwsValue())
}
object DetailsMap {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.DetailsMap
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.DetailsMap =
      zio.aws.lakeformation.model.DetailsMap(resourceShare.map(value => value))
    def resourceShare: Option[List[RAMResourceShareArn]]
    def getResourceShare: ZIO[Any, AwsError, List[RAMResourceShareArn]] =
      AwsError.unwrapOptionField("resourceShare", resourceShare)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.DetailsMap
  ) extends zio.aws.lakeformation.model.DetailsMap.ReadOnly {
    override val resourceShare: Option[List[RAMResourceShareArn]] = scala
      .Option(impl.resourceShare())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lakeformation.model.primitives.RAMResourceShareArn(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.DetailsMap
  ): zio.aws.lakeformation.model.DetailsMap.ReadOnly = new Wrapper(impl)
}
