package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeResourceResponse(
    resourceInfo: Option[zio.aws.lakeformation.model.ResourceInfo] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.DescribeResourceResponse = {
    import DescribeResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.DescribeResourceResponse
      .builder()
      .optionallyWith(resourceInfo.map(value => value.buildAwsValue()))(
        _.resourceInfo
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.DescribeResourceResponse.ReadOnly =
    zio.aws.lakeformation.model.DescribeResourceResponse.wrap(buildAwsValue())
}
object DescribeResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.DescribeResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.DescribeResourceResponse =
      zio.aws.lakeformation.model
        .DescribeResourceResponse(resourceInfo.map(value => value.asEditable))
    def resourceInfo: Option[zio.aws.lakeformation.model.ResourceInfo.ReadOnly]
    def getResourceInfo: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.ResourceInfo.ReadOnly
    ] = AwsError.unwrapOptionField("resourceInfo", resourceInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.DescribeResourceResponse
  ) extends zio.aws.lakeformation.model.DescribeResourceResponse.ReadOnly {
    override val resourceInfo
        : Option[zio.aws.lakeformation.model.ResourceInfo.ReadOnly] = scala
      .Option(impl.resourceInfo())
      .map(value => zio.aws.lakeformation.model.ResourceInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.DescribeResourceResponse
  ): zio.aws.lakeformation.model.DescribeResourceResponse.ReadOnly =
    new Wrapper(impl)
}
