package zio.aws.lakeformation.model
import scala.jdk.CollectionConverters._
sealed trait DataLakeResourceType {
  def unwrap
      : software.amazon.awssdk.services.lakeformation.model.DataLakeResourceType
}
object DataLakeResourceType {
  def wrap(
      value: software.amazon.awssdk.services.lakeformation.model.DataLakeResourceType
  ): zio.aws.lakeformation.model.DataLakeResourceType = value match {
    case software.amazon.awssdk.services.lakeformation.model.DataLakeResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lakeformation.model.DataLakeResourceType.CATALOG =>
      val r = CATALOG
      r
    case software.amazon.awssdk.services.lakeformation.model.DataLakeResourceType.DATABASE =>
      val r = DATABASE
      r
    case software.amazon.awssdk.services.lakeformation.model.DataLakeResourceType.TABLE =>
      val r = TABLE
      r
    case software.amazon.awssdk.services.lakeformation.model.DataLakeResourceType.DATA_LOCATION =>
      val r = DATA_LOCATION
      r
    case software.amazon.awssdk.services.lakeformation.model.DataLakeResourceType.LF_TAG =>
      val r = LF_TAG
      r
    case software.amazon.awssdk.services.lakeformation.model.DataLakeResourceType.LF_TAG_POLICY =>
      val r = LF_TAG_POLICY
      r
    case software.amazon.awssdk.services.lakeformation.model.DataLakeResourceType.LF_TAG_POLICY_DATABASE =>
      val r = LF_TAG_POLICY_DATABASE
      r
    case software.amazon.awssdk.services.lakeformation.model.DataLakeResourceType.LF_TAG_POLICY_TABLE =>
      val r = LF_TAG_POLICY_TABLE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lakeformation.model.DataLakeResourceType {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.DataLakeResourceType =
      software.amazon.awssdk.services.lakeformation.model.DataLakeResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object CATALOG extends zio.aws.lakeformation.model.DataLakeResourceType {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.DataLakeResourceType =
      software.amazon.awssdk.services.lakeformation.model.DataLakeResourceType.CATALOG
  }
  case object DATABASE
      extends zio.aws.lakeformation.model.DataLakeResourceType {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.DataLakeResourceType =
      software.amazon.awssdk.services.lakeformation.model.DataLakeResourceType.DATABASE
  }
  case object TABLE extends zio.aws.lakeformation.model.DataLakeResourceType {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.DataLakeResourceType =
      software.amazon.awssdk.services.lakeformation.model.DataLakeResourceType.TABLE
  }
  case object DATA_LOCATION
      extends zio.aws.lakeformation.model.DataLakeResourceType {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.DataLakeResourceType =
      software.amazon.awssdk.services.lakeformation.model.DataLakeResourceType.DATA_LOCATION
  }
  case object LF_TAG extends zio.aws.lakeformation.model.DataLakeResourceType {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.DataLakeResourceType =
      software.amazon.awssdk.services.lakeformation.model.DataLakeResourceType.LF_TAG
  }
  case object LF_TAG_POLICY
      extends zio.aws.lakeformation.model.DataLakeResourceType {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.DataLakeResourceType =
      software.amazon.awssdk.services.lakeformation.model.DataLakeResourceType.LF_TAG_POLICY
  }
  case object LF_TAG_POLICY_DATABASE
      extends zio.aws.lakeformation.model.DataLakeResourceType {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.DataLakeResourceType =
      software.amazon.awssdk.services.lakeformation.model.DataLakeResourceType.LF_TAG_POLICY_DATABASE
  }
  case object LF_TAG_POLICY_TABLE
      extends zio.aws.lakeformation.model.DataLakeResourceType {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.DataLakeResourceType =
      software.amazon.awssdk.services.lakeformation.model.DataLakeResourceType.LF_TAG_POLICY_TABLE
  }
}
