package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BatchPermissionsFailureEntry(
    requestEntry: Option[
      zio.aws.lakeformation.model.BatchPermissionsRequestEntry
    ] = None,
    error: Option[zio.aws.lakeformation.model.ErrorDetail] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.BatchPermissionsFailureEntry = {
    import BatchPermissionsFailureEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.BatchPermissionsFailureEntry
      .builder()
      .optionallyWith(requestEntry.map(value => value.buildAwsValue()))(
        _.requestEntry
      )
      .optionallyWith(error.map(value => value.buildAwsValue()))(_.error)
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.BatchPermissionsFailureEntry.ReadOnly =
    zio.aws.lakeformation.model.BatchPermissionsFailureEntry
      .wrap(buildAwsValue())
}
object BatchPermissionsFailureEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.BatchPermissionsFailureEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.BatchPermissionsFailureEntry =
      zio.aws.lakeformation.model.BatchPermissionsFailureEntry(
        requestEntry.map(value => value.asEditable),
        error.map(value => value.asEditable)
      )
    def requestEntry: Option[
      zio.aws.lakeformation.model.BatchPermissionsRequestEntry.ReadOnly
    ]
    def error: Option[zio.aws.lakeformation.model.ErrorDetail.ReadOnly]
    def getRequestEntry: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.BatchPermissionsRequestEntry.ReadOnly
    ] = AwsError.unwrapOptionField("requestEntry", requestEntry)
    def getError
        : ZIO[Any, AwsError, zio.aws.lakeformation.model.ErrorDetail.ReadOnly] =
      AwsError.unwrapOptionField("error", error)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.BatchPermissionsFailureEntry
  ) extends zio.aws.lakeformation.model.BatchPermissionsFailureEntry.ReadOnly {
    override val requestEntry: Option[
      zio.aws.lakeformation.model.BatchPermissionsRequestEntry.ReadOnly
    ] = scala
      .Option(impl.requestEntry())
      .map(value =>
        zio.aws.lakeformation.model.BatchPermissionsRequestEntry.wrap(value)
      )
    override val error
        : Option[zio.aws.lakeformation.model.ErrorDetail.ReadOnly] = scala
      .Option(impl.error())
      .map(value => zio.aws.lakeformation.model.ErrorDetail.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.BatchPermissionsFailureEntry
  ): zio.aws.lakeformation.model.BatchPermissionsFailureEntry.ReadOnly =
    new Wrapper(impl)
}
