package zio.aws.kms.model
import scala.jdk.CollectionConverters.*
sealed trait WrappingKeySpec {
  def unwrap: software.amazon.awssdk.services.kms.model.WrappingKeySpec
}
object WrappingKeySpec {
  def wrap(
      value: software.amazon.awssdk.services.kms.model.WrappingKeySpec
  ): zio.aws.kms.model.WrappingKeySpec = value match {
    case software.amazon.awssdk.services.kms.model.WrappingKeySpec.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kms.model.WrappingKeySpec.RSA_2048 =>
      val r = RSA_2048
      r
  }
  case object unknownToSdkVersion extends zio.aws.kms.model.WrappingKeySpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.WrappingKeySpec =
      software.amazon.awssdk.services.kms.model.WrappingKeySpec.UNKNOWN_TO_SDK_VERSION
  }
  case object RSA_2048 extends zio.aws.kms.model.WrappingKeySpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.WrappingKeySpec =
      software.amazon.awssdk.services.kms.model.WrappingKeySpec.RSA_2048
  }
}
