package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kms.model.primitives.{KeyIdType, AliasNameType}
import scala.jdk.CollectionConverters.*
final case class UpdateAliasRequest(
    aliasName: AliasNameType,
    targetKeyId: KeyIdType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.UpdateAliasRequest = {
    import UpdateAliasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.UpdateAliasRequest
      .builder()
      .aliasName(AliasNameType.unwrap(aliasName): java.lang.String)
      .targetKeyId(KeyIdType.unwrap(targetKeyId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.UpdateAliasRequest.ReadOnly =
    zio.aws.kms.model.UpdateAliasRequest.wrap(buildAwsValue())
}
object UpdateAliasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.UpdateAliasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.UpdateAliasRequest =
      zio.aws.kms.model.UpdateAliasRequest(aliasName, targetKeyId)
    def aliasName: AliasNameType
    def targetKeyId: KeyIdType
    def getAliasName: ZIO[Any, Nothing, AliasNameType] = ZIO.succeed(aliasName)
    def getTargetKeyId: ZIO[Any, Nothing, KeyIdType] = ZIO.succeed(targetKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.UpdateAliasRequest
  ) extends zio.aws.kms.model.UpdateAliasRequest.ReadOnly {
    override val aliasName: AliasNameType =
      zio.aws.kms.model.primitives.AliasNameType(impl.aliasName())
    override val targetKeyId: KeyIdType =
      zio.aws.kms.model.primitives.KeyIdType(impl.targetKeyId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.UpdateAliasRequest
  ): zio.aws.kms.model.UpdateAliasRequest.ReadOnly = new Wrapper(impl)
}
