package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{GrantIdType, KeyIdType, GrantTokenType}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RetireGrantRequest(
    grantToken: Optional[GrantTokenType] = Optional.Absent,
    keyId: Optional[KeyIdType] = Optional.Absent,
    grantId: Optional[GrantIdType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.RetireGrantRequest = {
    import RetireGrantRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.RetireGrantRequest
      .builder()
      .optionallyWith(
        grantToken.map(value => GrantTokenType.unwrap(value): java.lang.String)
      )(_.grantToken)
      .optionallyWith(
        keyId.map(value => KeyIdType.unwrap(value): java.lang.String)
      )(_.keyId)
      .optionallyWith(
        grantId.map(value => GrantIdType.unwrap(value): java.lang.String)
      )(_.grantId)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.RetireGrantRequest.ReadOnly =
    zio.aws.kms.model.RetireGrantRequest.wrap(buildAwsValue())
}
object RetireGrantRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.RetireGrantRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.RetireGrantRequest =
      zio.aws.kms.model.RetireGrantRequest(
        grantToken.map(value => value),
        keyId.map(value => value),
        grantId.map(value => value)
      )
    def grantToken: Optional[GrantTokenType]
    def keyId: Optional[KeyIdType]
    def grantId: Optional[GrantIdType]
    def getGrantToken: ZIO[Any, AwsError, GrantTokenType] =
      AwsError.unwrapOptionField("grantToken", grantToken)
    def getKeyId: ZIO[Any, AwsError, KeyIdType] =
      AwsError.unwrapOptionField("keyId", keyId)
    def getGrantId: ZIO[Any, AwsError, GrantIdType] =
      AwsError.unwrapOptionField("grantId", grantId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.RetireGrantRequest
  ) extends zio.aws.kms.model.RetireGrantRequest.ReadOnly {
    override val grantToken: Optional[GrantTokenType] = zio.aws.core.internal
      .optionalFromNullable(impl.grantToken())
      .map(value => zio.aws.kms.model.primitives.GrantTokenType(value))
    override val keyId: Optional[KeyIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.keyId())
      .map(value => zio.aws.kms.model.primitives.KeyIdType(value))
    override val grantId: Optional[GrantIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.grantId())
      .map(value => zio.aws.kms.model.primitives.GrantIdType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.RetireGrantRequest
  ): zio.aws.kms.model.RetireGrantRequest.ReadOnly = new Wrapper(impl)
}
