package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{
  EncryptionContextValue,
  EncryptionContextKey
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GrantConstraints(
    encryptionContextSubset: Optional[
      Map[EncryptionContextKey, EncryptionContextValue]
    ] = Optional.Absent,
    encryptionContextEquals: Optional[
      Map[EncryptionContextKey, EncryptionContextValue]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.GrantConstraints = {
    import GrantConstraints.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.GrantConstraints
      .builder()
      .optionallyWith(
        encryptionContextSubset.map(value =>
          value
            .map({ case (key, value) =>
              (EncryptionContextKey
                .unwrap(key): java.lang.String) -> (EncryptionContextValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.encryptionContextSubset)
      .optionallyWith(
        encryptionContextEquals.map(value =>
          value
            .map({ case (key, value) =>
              (EncryptionContextKey
                .unwrap(key): java.lang.String) -> (EncryptionContextValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.encryptionContextEquals)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.GrantConstraints.ReadOnly =
    zio.aws.kms.model.GrantConstraints.wrap(buildAwsValue())
}
object GrantConstraints {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.GrantConstraints
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.GrantConstraints =
      zio.aws.kms.model.GrantConstraints(
        encryptionContextSubset.map(value => value),
        encryptionContextEquals.map(value => value)
      )
    def encryptionContextSubset
        : Optional[Map[EncryptionContextKey, EncryptionContextValue]]
    def encryptionContextEquals
        : Optional[Map[EncryptionContextKey, EncryptionContextValue]]
    def getEncryptionContextSubset: ZIO[Any, AwsError, Map[
      EncryptionContextKey,
      EncryptionContextValue
    ]] = AwsError.unwrapOptionField(
      "encryptionContextSubset",
      encryptionContextSubset
    )
    def getEncryptionContextEquals: ZIO[Any, AwsError, Map[
      EncryptionContextKey,
      EncryptionContextValue
    ]] = AwsError.unwrapOptionField(
      "encryptionContextEquals",
      encryptionContextEquals
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.GrantConstraints
  ) extends zio.aws.kms.model.GrantConstraints.ReadOnly {
    override val encryptionContextSubset
        : Optional[Map[EncryptionContextKey, EncryptionContextValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionContextSubset())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.kms.model.primitives.EncryptionContextKey(
                key
              ) -> zio.aws.kms.model.primitives.EncryptionContextValue(value)
            })
            .toMap
        )
    override val encryptionContextEquals
        : Optional[Map[EncryptionContextKey, EncryptionContextValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionContextEquals())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.kms.model.primitives.EncryptionContextKey(
                key
              ) -> zio.aws.kms.model.primitives.EncryptionContextValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.GrantConstraints
  ): zio.aws.kms.model.GrantConstraints.ReadOnly = new Wrapper(impl)
}
