package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{PublicKeyType, KeyIdType}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetPublicKeyResponse(
    keyId: Optional[KeyIdType] = Optional.Absent,
    publicKey: Optional[PublicKeyType] = Optional.Absent,
    customerMasterKeySpec: Optional[zio.aws.kms.model.CustomerMasterKeySpec] =
      Optional.Absent,
    keySpec: Optional[zio.aws.kms.model.KeySpec] = Optional.Absent,
    keyUsage: Optional[zio.aws.kms.model.KeyUsageType] = Optional.Absent,
    encryptionAlgorithms: Optional[
      Iterable[zio.aws.kms.model.EncryptionAlgorithmSpec]
    ] = Optional.Absent,
    signingAlgorithms: Optional[
      Iterable[zio.aws.kms.model.SigningAlgorithmSpec]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.GetPublicKeyResponse = {
    import GetPublicKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.GetPublicKeyResponse
      .builder()
      .optionallyWith(
        keyId.map(value => KeyIdType.unwrap(value): java.lang.String)
      )(_.keyId)
      .optionallyWith(
        publicKey.map(value =>
          software.amazon.awssdk.core.SdkBytes.fromByteArrayUnsafe(
            value.toArray[Byte]
          )
        )
      )(_.publicKey)
      .optionallyWith(customerMasterKeySpec.map(value => value.unwrap))(
        _.customerMasterKeySpec
      )
      .optionallyWith(keySpec.map(value => value.unwrap))(_.keySpec)
      .optionallyWith(keyUsage.map(value => value.unwrap))(_.keyUsage)
      .optionallyWith(
        encryptionAlgorithms.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.encryptionAlgorithmsWithStrings)
      .optionallyWith(
        signingAlgorithms.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.signingAlgorithmsWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.GetPublicKeyResponse.ReadOnly =
    zio.aws.kms.model.GetPublicKeyResponse.wrap(buildAwsValue())
}
object GetPublicKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.GetPublicKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.GetPublicKeyResponse =
      zio.aws.kms.model.GetPublicKeyResponse(
        keyId.map(value => value),
        publicKey.map(value => value),
        customerMasterKeySpec.map(value => value),
        keySpec.map(value => value),
        keyUsage.map(value => value),
        encryptionAlgorithms.map(value => value),
        signingAlgorithms.map(value => value)
      )
    def keyId: Optional[KeyIdType]
    def publicKey: Optional[PublicKeyType]
    def customerMasterKeySpec: Optional[zio.aws.kms.model.CustomerMasterKeySpec]
    def keySpec: Optional[zio.aws.kms.model.KeySpec]
    def keyUsage: Optional[zio.aws.kms.model.KeyUsageType]
    def encryptionAlgorithms
        : Optional[List[zio.aws.kms.model.EncryptionAlgorithmSpec]]
    def signingAlgorithms
        : Optional[List[zio.aws.kms.model.SigningAlgorithmSpec]]
    def getKeyId: ZIO[Any, AwsError, KeyIdType] =
      AwsError.unwrapOptionField("keyId", keyId)
    def getPublicKey: ZIO[Any, AwsError, PublicKeyType] =
      AwsError.unwrapOptionField("publicKey", publicKey)
    def getCustomerMasterKeySpec
        : ZIO[Any, AwsError, zio.aws.kms.model.CustomerMasterKeySpec] =
      AwsError.unwrapOptionField("customerMasterKeySpec", customerMasterKeySpec)
    def getKeySpec: ZIO[Any, AwsError, zio.aws.kms.model.KeySpec] =
      AwsError.unwrapOptionField("keySpec", keySpec)
    def getKeyUsage: ZIO[Any, AwsError, zio.aws.kms.model.KeyUsageType] =
      AwsError.unwrapOptionField("keyUsage", keyUsage)
    def getEncryptionAlgorithms
        : ZIO[Any, AwsError, List[zio.aws.kms.model.EncryptionAlgorithmSpec]] =
      AwsError.unwrapOptionField("encryptionAlgorithms", encryptionAlgorithms)
    def getSigningAlgorithms
        : ZIO[Any, AwsError, List[zio.aws.kms.model.SigningAlgorithmSpec]] =
      AwsError.unwrapOptionField("signingAlgorithms", signingAlgorithms)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.GetPublicKeyResponse
  ) extends zio.aws.kms.model.GetPublicKeyResponse.ReadOnly {
    override val keyId: Optional[KeyIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.keyId())
      .map(value => zio.aws.kms.model.primitives.KeyIdType(value))
    override val publicKey: Optional[PublicKeyType] = zio.aws.core.internal
      .optionalFromNullable(impl.publicKey())
      .map(value =>
        zio.aws.kms.model.primitives
          .PublicKeyType(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val customerMasterKeySpec
        : Optional[zio.aws.kms.model.CustomerMasterKeySpec] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customerMasterKeySpec())
        .map(value => zio.aws.kms.model.CustomerMasterKeySpec.wrap(value))
    override val keySpec: Optional[zio.aws.kms.model.KeySpec] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keySpec())
        .map(value => zio.aws.kms.model.KeySpec.wrap(value))
    override val keyUsage: Optional[zio.aws.kms.model.KeyUsageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyUsage())
        .map(value => zio.aws.kms.model.KeyUsageType.wrap(value))
    override val encryptionAlgorithms
        : Optional[List[zio.aws.kms.model.EncryptionAlgorithmSpec]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionAlgorithms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kms.model.EncryptionAlgorithmSpec.wrap(item)
          }.toList
        )
    override val signingAlgorithms
        : Optional[List[zio.aws.kms.model.SigningAlgorithmSpec]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.signingAlgorithms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kms.model.SigningAlgorithmSpec.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.GetPublicKeyResponse
  ): zio.aws.kms.model.GetPublicKeyResponse.ReadOnly = new Wrapper(impl)
}
