package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{KeyIdType, CiphertextType}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GenerateMacResponse(
    mac: Optional[CiphertextType] = Optional.Absent,
    macAlgorithm: Optional[zio.aws.kms.model.MacAlgorithmSpec] =
      Optional.Absent,
    keyId: Optional[KeyIdType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.GenerateMacResponse = {
    import GenerateMacResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.GenerateMacResponse
      .builder()
      .optionallyWith(
        mac.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.mac)
      .optionallyWith(macAlgorithm.map(value => value.unwrap))(_.macAlgorithm)
      .optionallyWith(
        keyId.map(value => KeyIdType.unwrap(value): java.lang.String)
      )(_.keyId)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.GenerateMacResponse.ReadOnly =
    zio.aws.kms.model.GenerateMacResponse.wrap(buildAwsValue())
}
object GenerateMacResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.GenerateMacResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.GenerateMacResponse =
      zio.aws.kms.model.GenerateMacResponse(
        mac.map(value => value),
        macAlgorithm.map(value => value),
        keyId.map(value => value)
      )
    def mac: Optional[CiphertextType]
    def macAlgorithm: Optional[zio.aws.kms.model.MacAlgorithmSpec]
    def keyId: Optional[KeyIdType]
    def getMac: ZIO[Any, AwsError, CiphertextType] =
      AwsError.unwrapOptionField("mac", mac)
    def getMacAlgorithm
        : ZIO[Any, AwsError, zio.aws.kms.model.MacAlgorithmSpec] =
      AwsError.unwrapOptionField("macAlgorithm", macAlgorithm)
    def getKeyId: ZIO[Any, AwsError, KeyIdType] =
      AwsError.unwrapOptionField("keyId", keyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.GenerateMacResponse
  ) extends zio.aws.kms.model.GenerateMacResponse.ReadOnly {
    override val mac: Optional[CiphertextType] = zio.aws.core.internal
      .optionalFromNullable(impl.mac())
      .map(value =>
        zio.aws.kms.model.primitives
          .CiphertextType(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val macAlgorithm: Optional[zio.aws.kms.model.MacAlgorithmSpec] =
      zio.aws.core.internal
        .optionalFromNullable(impl.macAlgorithm())
        .map(value => zio.aws.kms.model.MacAlgorithmSpec.wrap(value))
    override val keyId: Optional[KeyIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.keyId())
      .map(value => zio.aws.kms.model.primitives.KeyIdType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.GenerateMacResponse
  ): zio.aws.kms.model.GenerateMacResponse.ReadOnly = new Wrapper(impl)
}
