package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{KeyIdType, CiphertextType}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GenerateDataKeyWithoutPlaintextResponse(
    ciphertextBlob: Optional[CiphertextType] = Optional.Absent,
    keyId: Optional[KeyIdType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.GenerateDataKeyWithoutPlaintextResponse = {
    import GenerateDataKeyWithoutPlaintextResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.GenerateDataKeyWithoutPlaintextResponse
      .builder()
      .optionallyWith(
        ciphertextBlob.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.ciphertextBlob)
      .optionallyWith(
        keyId.map(value => KeyIdType.unwrap(value): java.lang.String)
      )(_.keyId)
      .build()
  }
  def asReadOnly
      : zio.aws.kms.model.GenerateDataKeyWithoutPlaintextResponse.ReadOnly =
    zio.aws.kms.model.GenerateDataKeyWithoutPlaintextResponse
      .wrap(buildAwsValue())
}
object GenerateDataKeyWithoutPlaintextResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.GenerateDataKeyWithoutPlaintextResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.GenerateDataKeyWithoutPlaintextResponse =
      zio.aws.kms.model.GenerateDataKeyWithoutPlaintextResponse(
        ciphertextBlob.map(value => value),
        keyId.map(value => value)
      )
    def ciphertextBlob: Optional[CiphertextType]
    def keyId: Optional[KeyIdType]
    def getCiphertextBlob: ZIO[Any, AwsError, CiphertextType] =
      AwsError.unwrapOptionField("ciphertextBlob", ciphertextBlob)
    def getKeyId: ZIO[Any, AwsError, KeyIdType] =
      AwsError.unwrapOptionField("keyId", keyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.GenerateDataKeyWithoutPlaintextResponse
  ) extends zio.aws.kms.model.GenerateDataKeyWithoutPlaintextResponse.ReadOnly {
    override val ciphertextBlob: Optional[CiphertextType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ciphertextBlob())
        .map(value =>
          zio.aws.kms.model.primitives
            .CiphertextType(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
        )
    override val keyId: Optional[KeyIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.keyId())
      .map(value => zio.aws.kms.model.primitives.KeyIdType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.GenerateDataKeyWithoutPlaintextResponse
  ): zio.aws.kms.model.GenerateDataKeyWithoutPlaintextResponse.ReadOnly =
    new Wrapper(impl)
}
