package zio.aws.kms.model
import zio.prelude.data.Optional
import zio.aws.kms.model.primitives.{
  GrantTokenType,
  KeyIdType,
  EncryptionContextValue,
  NumberOfBytesType,
  EncryptionContextKey
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GenerateDataKeyRequest(
    keyId: KeyIdType,
    encryptionContext: Optional[
      Map[EncryptionContextKey, EncryptionContextValue]
    ] = Optional.Absent,
    numberOfBytes: Optional[NumberOfBytesType] = Optional.Absent,
    keySpec: Optional[zio.aws.kms.model.DataKeySpec] = Optional.Absent,
    grantTokens: Optional[Iterable[GrantTokenType]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.GenerateDataKeyRequest = {
    import GenerateDataKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.GenerateDataKeyRequest
      .builder()
      .keyId(KeyIdType.unwrap(keyId): java.lang.String)
      .optionallyWith(
        encryptionContext.map(value =>
          value
            .map({ case (key, value) =>
              (EncryptionContextKey.unwrap(
                key
              ): java.lang.String) -> (EncryptionContextValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.encryptionContext)
      .optionallyWith(
        numberOfBytes.map(value => NumberOfBytesType.unwrap(value): Integer)
      )(_.numberOfBytes)
      .optionallyWith(keySpec.map(value => value.unwrap))(_.keySpec)
      .optionallyWith(
        grantTokens.map(value =>
          value.map { item =>
            GrantTokenType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.grantTokens)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.GenerateDataKeyRequest.ReadOnly =
    zio.aws.kms.model.GenerateDataKeyRequest.wrap(buildAwsValue())
}
object GenerateDataKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.GenerateDataKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.GenerateDataKeyRequest =
      zio.aws.kms.model.GenerateDataKeyRequest(
        keyId,
        encryptionContext.map(value => value),
        numberOfBytes.map(value => value),
        keySpec.map(value => value),
        grantTokens.map(value => value)
      )
    def keyId: KeyIdType
    def encryptionContext
        : Optional[Map[EncryptionContextKey, EncryptionContextValue]]
    def numberOfBytes: Optional[NumberOfBytesType]
    def keySpec: Optional[zio.aws.kms.model.DataKeySpec]
    def grantTokens: Optional[List[GrantTokenType]]
    def getKeyId: ZIO[Any, Nothing, KeyIdType] = ZIO.succeed(keyId)
    def getEncryptionContext: ZIO[Any, AwsError, Map[
      EncryptionContextKey,
      EncryptionContextValue
    ]] = AwsError.unwrapOptionField("encryptionContext", encryptionContext)
    def getNumberOfBytes: ZIO[Any, AwsError, NumberOfBytesType] =
      AwsError.unwrapOptionField("numberOfBytes", numberOfBytes)
    def getKeySpec: ZIO[Any, AwsError, zio.aws.kms.model.DataKeySpec] =
      AwsError.unwrapOptionField("keySpec", keySpec)
    def getGrantTokens: ZIO[Any, AwsError, List[GrantTokenType]] =
      AwsError.unwrapOptionField("grantTokens", grantTokens)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.GenerateDataKeyRequest
  ) extends zio.aws.kms.model.GenerateDataKeyRequest.ReadOnly {
    override val keyId: KeyIdType =
      zio.aws.kms.model.primitives.KeyIdType(impl.keyId())
    override val encryptionContext
        : Optional[Map[EncryptionContextKey, EncryptionContextValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionContext())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.kms.model.primitives.EncryptionContextKey(
                key
              ) -> zio.aws.kms.model.primitives.EncryptionContextValue(value)
            })
            .toMap
        )
    override val numberOfBytes: Optional[NumberOfBytesType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfBytes())
        .map(value => zio.aws.kms.model.primitives.NumberOfBytesType(value))
    override val keySpec: Optional[zio.aws.kms.model.DataKeySpec] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keySpec())
        .map(value => zio.aws.kms.model.DataKeySpec.wrap(value))
    override val grantTokens: Optional[List[GrantTokenType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.grantTokens())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kms.model.primitives.GrantTokenType(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.GenerateDataKeyRequest
  ): zio.aws.kms.model.GenerateDataKeyRequest.ReadOnly = new Wrapper(impl)
}
