package zio.aws.kms.model
import scala.jdk.CollectionConverters.*
sealed trait ExpirationModelType {
  def unwrap: software.amazon.awssdk.services.kms.model.ExpirationModelType
}
object ExpirationModelType {
  def wrap(
      value: software.amazon.awssdk.services.kms.model.ExpirationModelType
  ): zio.aws.kms.model.ExpirationModelType = value match {
    case software.amazon.awssdk.services.kms.model.ExpirationModelType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kms.model.ExpirationModelType.KEY_MATERIAL_EXPIRES =>
      val r = KEY_MATERIAL_EXPIRES
      r
    case software.amazon.awssdk.services.kms.model.ExpirationModelType.KEY_MATERIAL_DOES_NOT_EXPIRE =>
      val r = KEY_MATERIAL_DOES_NOT_EXPIRE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kms.model.ExpirationModelType {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.ExpirationModelType =
      software.amazon.awssdk.services.kms.model.ExpirationModelType.UNKNOWN_TO_SDK_VERSION
  }
  case object KEY_MATERIAL_EXPIRES
      extends zio.aws.kms.model.ExpirationModelType {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.ExpirationModelType =
      software.amazon.awssdk.services.kms.model.ExpirationModelType.KEY_MATERIAL_EXPIRES
  }
  case object KEY_MATERIAL_DOES_NOT_EXPIRE
      extends zio.aws.kms.model.ExpirationModelType {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.ExpirationModelType =
      software.amazon.awssdk.services.kms.model.ExpirationModelType.KEY_MATERIAL_DOES_NOT_EXPIRE
  }
}
