package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kms.model.primitives.CustomKeyStoreIdType
import scala.jdk.CollectionConverters.*
final case class DeleteCustomKeyStoreRequest(
    customKeyStoreId: CustomKeyStoreIdType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.DeleteCustomKeyStoreRequest = {
    import DeleteCustomKeyStoreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.DeleteCustomKeyStoreRequest
      .builder()
      .customKeyStoreId(
        CustomKeyStoreIdType.unwrap(customKeyStoreId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.kms.model.DeleteCustomKeyStoreRequest.ReadOnly =
    zio.aws.kms.model.DeleteCustomKeyStoreRequest.wrap(buildAwsValue())
}
object DeleteCustomKeyStoreRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.DeleteCustomKeyStoreRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.DeleteCustomKeyStoreRequest =
      zio.aws.kms.model.DeleteCustomKeyStoreRequest(customKeyStoreId)
    def customKeyStoreId: CustomKeyStoreIdType
    def getCustomKeyStoreId: ZIO[Any, Nothing, CustomKeyStoreIdType] =
      ZIO.succeed(customKeyStoreId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.DeleteCustomKeyStoreRequest
  ) extends zio.aws.kms.model.DeleteCustomKeyStoreRequest.ReadOnly {
    override val customKeyStoreId: CustomKeyStoreIdType =
      zio.aws.kms.model.primitives.CustomKeyStoreIdType(impl.customKeyStoreId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.DeleteCustomKeyStoreRequest
  ): zio.aws.kms.model.DeleteCustomKeyStoreRequest.ReadOnly = new Wrapper(impl)
}
