package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kms.model.primitives.{KeyIdType, AliasNameType}
import scala.jdk.CollectionConverters.*
final case class CreateAliasRequest(
    aliasName: AliasNameType,
    targetKeyId: KeyIdType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.CreateAliasRequest = {
    import CreateAliasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.CreateAliasRequest
      .builder()
      .aliasName(AliasNameType.unwrap(aliasName): java.lang.String)
      .targetKeyId(KeyIdType.unwrap(targetKeyId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.CreateAliasRequest.ReadOnly =
    zio.aws.kms.model.CreateAliasRequest.wrap(buildAwsValue())
}
object CreateAliasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.CreateAliasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.CreateAliasRequest =
      zio.aws.kms.model.CreateAliasRequest(aliasName, targetKeyId)
    def aliasName: AliasNameType
    def targetKeyId: KeyIdType
    def getAliasName: ZIO[Any, Nothing, AliasNameType] = ZIO.succeed(aliasName)
    def getTargetKeyId: ZIO[Any, Nothing, KeyIdType] = ZIO.succeed(targetKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.CreateAliasRequest
  ) extends zio.aws.kms.model.CreateAliasRequest.ReadOnly {
    override val aliasName: AliasNameType =
      zio.aws.kms.model.primitives.AliasNameType(impl.aliasName())
    override val targetKeyId: KeyIdType =
      zio.aws.kms.model.primitives.KeyIdType(impl.targetKeyId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.CreateAliasRequest
  ): zio.aws.kms.model.CreateAliasRequest.ReadOnly = new Wrapper(impl)
}
