package zio.aws.kms.model
import scala.jdk.CollectionConverters.*
sealed trait ConnectionErrorCodeType {
  def unwrap: software.amazon.awssdk.services.kms.model.ConnectionErrorCodeType
}
object ConnectionErrorCodeType {
  def wrap(
      value: software.amazon.awssdk.services.kms.model.ConnectionErrorCodeType
  ): zio.aws.kms.model.ConnectionErrorCodeType = value match {
    case software.amazon.awssdk.services.kms.model.ConnectionErrorCodeType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kms.model.ConnectionErrorCodeType.INVALID_CREDENTIALS =>
      val r = INVALID_CREDENTIALS
      r
    case software.amazon.awssdk.services.kms.model.ConnectionErrorCodeType.CLUSTER_NOT_FOUND =>
      val r = CLUSTER_NOT_FOUND
      r
    case software.amazon.awssdk.services.kms.model.ConnectionErrorCodeType.NETWORK_ERRORS =>
      val r = NETWORK_ERRORS
      r
    case software.amazon.awssdk.services.kms.model.ConnectionErrorCodeType.INTERNAL_ERROR =>
      val r = INTERNAL_ERROR
      r
    case software.amazon.awssdk.services.kms.model.ConnectionErrorCodeType.INSUFFICIENT_CLOUDHSM_HSMS =>
      val r = INSUFFICIENT_CLOUDHSM_HSMS
      r
    case software.amazon.awssdk.services.kms.model.ConnectionErrorCodeType.USER_LOCKED_OUT =>
      val r = USER_LOCKED_OUT
      r
    case software.amazon.awssdk.services.kms.model.ConnectionErrorCodeType.USER_NOT_FOUND =>
      val r = USER_NOT_FOUND
      r
    case software.amazon.awssdk.services.kms.model.ConnectionErrorCodeType.USER_LOGGED_IN =>
      val r = USER_LOGGED_IN
      r
    case software.amazon.awssdk.services.kms.model.ConnectionErrorCodeType.SUBNET_NOT_FOUND =>
      val r = SUBNET_NOT_FOUND
      r
    case software.amazon.awssdk.services.kms.model.ConnectionErrorCodeType.INSUFFICIENT_FREE_ADDRESSES_IN_SUBNET =>
      val r = INSUFFICIENT_FREE_ADDRESSES_IN_SUBNET
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kms.model.ConnectionErrorCodeType {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.ConnectionErrorCodeType =
      software.amazon.awssdk.services.kms.model.ConnectionErrorCodeType.UNKNOWN_TO_SDK_VERSION
  }
  case object INVALID_CREDENTIALS
      extends zio.aws.kms.model.ConnectionErrorCodeType {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.ConnectionErrorCodeType =
      software.amazon.awssdk.services.kms.model.ConnectionErrorCodeType.INVALID_CREDENTIALS
  }
  case object CLUSTER_NOT_FOUND
      extends zio.aws.kms.model.ConnectionErrorCodeType {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.ConnectionErrorCodeType =
      software.amazon.awssdk.services.kms.model.ConnectionErrorCodeType.CLUSTER_NOT_FOUND
  }
  case object NETWORK_ERRORS extends zio.aws.kms.model.ConnectionErrorCodeType {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.ConnectionErrorCodeType =
      software.amazon.awssdk.services.kms.model.ConnectionErrorCodeType.NETWORK_ERRORS
  }
  case object INTERNAL_ERROR extends zio.aws.kms.model.ConnectionErrorCodeType {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.ConnectionErrorCodeType =
      software.amazon.awssdk.services.kms.model.ConnectionErrorCodeType.INTERNAL_ERROR
  }
  case object INSUFFICIENT_CLOUDHSM_HSMS
      extends zio.aws.kms.model.ConnectionErrorCodeType {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.ConnectionErrorCodeType =
      software.amazon.awssdk.services.kms.model.ConnectionErrorCodeType.INSUFFICIENT_CLOUDHSM_HSMS
  }
  case object USER_LOCKED_OUT
      extends zio.aws.kms.model.ConnectionErrorCodeType {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.ConnectionErrorCodeType =
      software.amazon.awssdk.services.kms.model.ConnectionErrorCodeType.USER_LOCKED_OUT
  }
  case object USER_NOT_FOUND extends zio.aws.kms.model.ConnectionErrorCodeType {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.ConnectionErrorCodeType =
      software.amazon.awssdk.services.kms.model.ConnectionErrorCodeType.USER_NOT_FOUND
  }
  case object USER_LOGGED_IN extends zio.aws.kms.model.ConnectionErrorCodeType {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.ConnectionErrorCodeType =
      software.amazon.awssdk.services.kms.model.ConnectionErrorCodeType.USER_LOGGED_IN
  }
  case object SUBNET_NOT_FOUND
      extends zio.aws.kms.model.ConnectionErrorCodeType {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.ConnectionErrorCodeType =
      software.amazon.awssdk.services.kms.model.ConnectionErrorCodeType.SUBNET_NOT_FOUND
  }
  case object INSUFFICIENT_FREE_ADDRESSES_IN_SUBNET
      extends zio.aws.kms.model.ConnectionErrorCodeType {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.ConnectionErrorCodeType =
      software.amazon.awssdk.services.kms.model.ConnectionErrorCodeType.INSUFFICIENT_FREE_ADDRESSES_IN_SUBNET
  }
}
