package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kms.model.primitives.KeyIdType
import scala.jdk.CollectionConverters.*
final case class CancelKeyDeletionRequest(keyId: KeyIdType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.CancelKeyDeletionRequest = {
    import CancelKeyDeletionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.CancelKeyDeletionRequest
      .builder()
      .keyId(KeyIdType.unwrap(keyId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.CancelKeyDeletionRequest.ReadOnly =
    zio.aws.kms.model.CancelKeyDeletionRequest.wrap(buildAwsValue())
}
object CancelKeyDeletionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.CancelKeyDeletionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.CancelKeyDeletionRequest =
      zio.aws.kms.model.CancelKeyDeletionRequest(keyId)
    def keyId: KeyIdType
    def getKeyId: ZIO[Any, Nothing, KeyIdType] = ZIO.succeed(keyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.CancelKeyDeletionRequest
  ) extends zio.aws.kms.model.CancelKeyDeletionRequest.ReadOnly {
    override val keyId: KeyIdType =
      zio.aws.kms.model.primitives.KeyIdType(impl.keyId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.CancelKeyDeletionRequest
  ): zio.aws.kms.model.CancelKeyDeletionRequest.ReadOnly = new Wrapper(impl)
}
