package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{BooleanType, KeyIdType}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class VerifyResponse(
    keyId: Optional[KeyIdType] = Optional.Absent,
    signatureValid: Optional[BooleanType] = Optional.Absent,
    signingAlgorithm: Optional[zio.aws.kms.model.SigningAlgorithmSpec] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.VerifyResponse = {
    import VerifyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.VerifyResponse
      .builder()
      .optionallyWith(
        keyId.map(value => KeyIdType.unwrap(value): java.lang.String)
      )(_.keyId)
      .optionallyWith(
        signatureValid.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.signatureValid)
      .optionallyWith(signingAlgorithm.map(value => value.unwrap))(
        _.signingAlgorithm
      )
      .build()
  }
  def asReadOnly: zio.aws.kms.model.VerifyResponse.ReadOnly =
    zio.aws.kms.model.VerifyResponse.wrap(buildAwsValue())
}
object VerifyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.VerifyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.VerifyResponse =
      zio.aws.kms.model.VerifyResponse(
        keyId.map(value => value),
        signatureValid.map(value => value),
        signingAlgorithm.map(value => value)
      )
    def keyId: Optional[KeyIdType]
    def signatureValid: Optional[BooleanType]
    def signingAlgorithm: Optional[zio.aws.kms.model.SigningAlgorithmSpec]
    def getKeyId: ZIO[Any, AwsError, KeyIdType] =
      AwsError.unwrapOptionField("keyId", keyId)
    def getSignatureValid: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("signatureValid", signatureValid)
    def getSigningAlgorithm
        : ZIO[Any, AwsError, zio.aws.kms.model.SigningAlgorithmSpec] =
      AwsError.unwrapOptionField("signingAlgorithm", signingAlgorithm)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.VerifyResponse
  ) extends zio.aws.kms.model.VerifyResponse.ReadOnly {
    override val keyId: Optional[KeyIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.keyId())
      .map(value => zio.aws.kms.model.primitives.KeyIdType(value))
    override val signatureValid: Optional[BooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.signatureValid())
      .map(value => zio.aws.kms.model.primitives.BooleanType(value))
    override val signingAlgorithm
        : Optional[zio.aws.kms.model.SigningAlgorithmSpec] =
      zio.aws.core.internal
        .optionalFromNullable(impl.signingAlgorithm())
        .map(value => zio.aws.kms.model.SigningAlgorithmSpec.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.VerifyResponse
  ): zio.aws.kms.model.VerifyResponse.ReadOnly = new Wrapper(impl)
}
