package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kms.model.primitives.KeyIdType
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    keyId: KeyIdType,
    tags: Iterable[zio.aws.kms.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.TagResourceRequest
      .builder()
      .keyId(KeyIdType.unwrap(keyId): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.TagResourceRequest.ReadOnly =
    zio.aws.kms.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.TagResourceRequest =
      zio.aws.kms.model.TagResourceRequest(
        keyId,
        tags.map { item =>
          item.asEditable
        }
      )
    def keyId: KeyIdType
    def tags: List[zio.aws.kms.model.Tag.ReadOnly]
    def getKeyId: ZIO[Any, Nothing, KeyIdType] = ZIO.succeed(keyId)
    def getTags: ZIO[Any, Nothing, List[zio.aws.kms.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.TagResourceRequest
  ) extends zio.aws.kms.model.TagResourceRequest.ReadOnly {
    override val keyId: KeyIdType =
      zio.aws.kms.model.primitives.KeyIdType(impl.keyId())
    override val tags: List[zio.aws.kms.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.kms.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.TagResourceRequest
  ): zio.aws.kms.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
