package zio.aws.kms.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.kms.model.primitives.{
  PendingWindowInDaysType,
  DateType,
  KeyIdType
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ScheduleKeyDeletionResponse(
    keyId: Optional[KeyIdType] = Optional.Absent,
    deletionDate: Optional[DateType] = Optional.Absent,
    keyState: Optional[zio.aws.kms.model.KeyState] = Optional.Absent,
    pendingWindowInDays: Optional[PendingWindowInDaysType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.ScheduleKeyDeletionResponse = {
    import ScheduleKeyDeletionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.ScheduleKeyDeletionResponse
      .builder()
      .optionallyWith(
        keyId.map(value => KeyIdType.unwrap(value): java.lang.String)
      )(_.keyId)
      .optionallyWith(
        deletionDate.map(value => DateType.unwrap(value): Instant)
      )(_.deletionDate)
      .optionallyWith(keyState.map(value => value.unwrap))(_.keyState)
      .optionallyWith(
        pendingWindowInDays.map(value =>
          PendingWindowInDaysType.unwrap(value): Integer
        )
      )(_.pendingWindowInDays)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.ScheduleKeyDeletionResponse.ReadOnly =
    zio.aws.kms.model.ScheduleKeyDeletionResponse.wrap(buildAwsValue())
}
object ScheduleKeyDeletionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.ScheduleKeyDeletionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.ScheduleKeyDeletionResponse =
      zio.aws.kms.model.ScheduleKeyDeletionResponse(
        keyId.map(value => value),
        deletionDate.map(value => value),
        keyState.map(value => value),
        pendingWindowInDays.map(value => value)
      )
    def keyId: Optional[KeyIdType]
    def deletionDate: Optional[DateType]
    def keyState: Optional[zio.aws.kms.model.KeyState]
    def pendingWindowInDays: Optional[PendingWindowInDaysType]
    def getKeyId: ZIO[Any, AwsError, KeyIdType] =
      AwsError.unwrapOptionField("keyId", keyId)
    def getDeletionDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("deletionDate", deletionDate)
    def getKeyState: ZIO[Any, AwsError, zio.aws.kms.model.KeyState] =
      AwsError.unwrapOptionField("keyState", keyState)
    def getPendingWindowInDays: ZIO[Any, AwsError, PendingWindowInDaysType] =
      AwsError.unwrapOptionField("pendingWindowInDays", pendingWindowInDays)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.ScheduleKeyDeletionResponse
  ) extends zio.aws.kms.model.ScheduleKeyDeletionResponse.ReadOnly {
    override val keyId: Optional[KeyIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.keyId())
      .map(value => zio.aws.kms.model.primitives.KeyIdType(value))
    override val deletionDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.deletionDate())
      .map(value => zio.aws.kms.model.primitives.DateType(value))
    override val keyState: Optional[zio.aws.kms.model.KeyState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyState())
        .map(value => zio.aws.kms.model.KeyState.wrap(value))
    override val pendingWindowInDays: Optional[PendingWindowInDaysType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pendingWindowInDays())
        .map(value =>
          zio.aws.kms.model.primitives.PendingWindowInDaysType(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.ScheduleKeyDeletionResponse
  ): zio.aws.kms.model.ScheduleKeyDeletionResponse.ReadOnly = new Wrapper(impl)
}
