package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{KeyIdType, CiphertextType}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ReEncryptResponse(
    ciphertextBlob: Optional[CiphertextType] = Optional.Absent,
    sourceKeyId: Optional[KeyIdType] = Optional.Absent,
    keyId: Optional[KeyIdType] = Optional.Absent,
    sourceEncryptionAlgorithm: Optional[
      zio.aws.kms.model.EncryptionAlgorithmSpec
    ] = Optional.Absent,
    destinationEncryptionAlgorithm: Optional[
      zio.aws.kms.model.EncryptionAlgorithmSpec
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.ReEncryptResponse = {
    import ReEncryptResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.ReEncryptResponse
      .builder()
      .optionallyWith(
        ciphertextBlob.map(value =>
          software.amazon.awssdk.core.SdkBytes.fromByteArrayUnsafe(
            value.toArray[Byte]
          )
        )
      )(_.ciphertextBlob)
      .optionallyWith(
        sourceKeyId.map(value => KeyIdType.unwrap(value): java.lang.String)
      )(_.sourceKeyId)
      .optionallyWith(
        keyId.map(value => KeyIdType.unwrap(value): java.lang.String)
      )(_.keyId)
      .optionallyWith(sourceEncryptionAlgorithm.map(value => value.unwrap))(
        _.sourceEncryptionAlgorithm
      )
      .optionallyWith(
        destinationEncryptionAlgorithm.map(value => value.unwrap)
      )(_.destinationEncryptionAlgorithm)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.ReEncryptResponse.ReadOnly =
    zio.aws.kms.model.ReEncryptResponse.wrap(buildAwsValue())
}
object ReEncryptResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.ReEncryptResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.ReEncryptResponse =
      zio.aws.kms.model.ReEncryptResponse(
        ciphertextBlob.map(value => value),
        sourceKeyId.map(value => value),
        keyId.map(value => value),
        sourceEncryptionAlgorithm.map(value => value),
        destinationEncryptionAlgorithm.map(value => value)
      )
    def ciphertextBlob: Optional[CiphertextType]
    def sourceKeyId: Optional[KeyIdType]
    def keyId: Optional[KeyIdType]
    def sourceEncryptionAlgorithm
        : Optional[zio.aws.kms.model.EncryptionAlgorithmSpec]
    def destinationEncryptionAlgorithm
        : Optional[zio.aws.kms.model.EncryptionAlgorithmSpec]
    def getCiphertextBlob: ZIO[Any, AwsError, CiphertextType] =
      AwsError.unwrapOptionField("ciphertextBlob", ciphertextBlob)
    def getSourceKeyId: ZIO[Any, AwsError, KeyIdType] =
      AwsError.unwrapOptionField("sourceKeyId", sourceKeyId)
    def getKeyId: ZIO[Any, AwsError, KeyIdType] =
      AwsError.unwrapOptionField("keyId", keyId)
    def getSourceEncryptionAlgorithm
        : ZIO[Any, AwsError, zio.aws.kms.model.EncryptionAlgorithmSpec] =
      AwsError.unwrapOptionField(
        "sourceEncryptionAlgorithm",
        sourceEncryptionAlgorithm
      )
    def getDestinationEncryptionAlgorithm
        : ZIO[Any, AwsError, zio.aws.kms.model.EncryptionAlgorithmSpec] =
      AwsError.unwrapOptionField(
        "destinationEncryptionAlgorithm",
        destinationEncryptionAlgorithm
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.ReEncryptResponse
  ) extends zio.aws.kms.model.ReEncryptResponse.ReadOnly {
    override val ciphertextBlob: Optional[CiphertextType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ciphertextBlob())
        .map(value =>
          zio.aws.kms.model.primitives
            .CiphertextType(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
        )
    override val sourceKeyId: Optional[KeyIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceKeyId())
      .map(value => zio.aws.kms.model.primitives.KeyIdType(value))
    override val keyId: Optional[KeyIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.keyId())
      .map(value => zio.aws.kms.model.primitives.KeyIdType(value))
    override val sourceEncryptionAlgorithm
        : Optional[zio.aws.kms.model.EncryptionAlgorithmSpec] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceEncryptionAlgorithm())
        .map(value => zio.aws.kms.model.EncryptionAlgorithmSpec.wrap(value))
    override val destinationEncryptionAlgorithm
        : Optional[zio.aws.kms.model.EncryptionAlgorithmSpec] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationEncryptionAlgorithm())
        .map(value => zio.aws.kms.model.EncryptionAlgorithmSpec.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.ReEncryptResponse
  ): zio.aws.kms.model.ReEncryptResponse.ReadOnly = new Wrapper(impl)
}
