package zio.aws.kms.model
import scala.jdk.CollectionConverters.*
sealed trait MessageType {
  def unwrap: software.amazon.awssdk.services.kms.model.MessageType
}
object MessageType {
  def wrap(
      value: software.amazon.awssdk.services.kms.model.MessageType
  ): zio.aws.kms.model.MessageType = value match {
    case software.amazon.awssdk.services.kms.model.MessageType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kms.model.MessageType.RAW =>
      val r = RAW
      r
    case software.amazon.awssdk.services.kms.model.MessageType.DIGEST =>
      val r = DIGEST
      r
  }
  case object unknownToSdkVersion extends zio.aws.kms.model.MessageType {
    override def unwrap: software.amazon.awssdk.services.kms.model.MessageType =
      software.amazon.awssdk.services.kms.model.MessageType.UNKNOWN_TO_SDK_VERSION
  }
  case object RAW extends zio.aws.kms.model.MessageType {
    override def unwrap: software.amazon.awssdk.services.kms.model.MessageType =
      software.amazon.awssdk.services.kms.model.MessageType.RAW
  }
  case object DIGEST extends zio.aws.kms.model.MessageType {
    override def unwrap: software.amazon.awssdk.services.kms.model.MessageType =
      software.amazon.awssdk.services.kms.model.MessageType.DIGEST
  }
}
