package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{BooleanType, MarkerType}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListRetirableGrantsResponse(
    grants: Optional[Iterable[zio.aws.kms.model.GrantListEntry]] =
      Optional.Absent,
    nextMarker: Optional[MarkerType] = Optional.Absent,
    truncated: Optional[BooleanType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.ListRetirableGrantsResponse = {
    import ListRetirableGrantsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.ListRetirableGrantsResponse
      .builder()
      .optionallyWith(
        grants.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.grants)
      .optionallyWith(
        nextMarker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        truncated.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.truncated)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.ListRetirableGrantsResponse.ReadOnly =
    zio.aws.kms.model.ListRetirableGrantsResponse.wrap(buildAwsValue())
}
object ListRetirableGrantsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.ListRetirableGrantsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.ListRetirableGrantsResponse =
      zio.aws.kms.model.ListRetirableGrantsResponse(
        grants.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextMarker.map(value => value),
        truncated.map(value => value)
      )
    def grants: Optional[List[zio.aws.kms.model.GrantListEntry.ReadOnly]]
    def nextMarker: Optional[MarkerType]
    def truncated: Optional[BooleanType]
    def getGrants
        : ZIO[Any, AwsError, List[zio.aws.kms.model.GrantListEntry.ReadOnly]] =
      AwsError.unwrapOptionField("grants", grants)
    def getNextMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getTruncated: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("truncated", truncated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.ListRetirableGrantsResponse
  ) extends zio.aws.kms.model.ListRetirableGrantsResponse.ReadOnly {
    override val grants
        : Optional[List[zio.aws.kms.model.GrantListEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.grants())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kms.model.GrantListEntry.wrap(item)
          }.toList
        )
    override val nextMarker: Optional[MarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => zio.aws.kms.model.primitives.MarkerType(value))
    override val truncated: Optional[BooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.truncated())
      .map(value => zio.aws.kms.model.primitives.BooleanType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.ListRetirableGrantsResponse
  ): zio.aws.kms.model.ListRetirableGrantsResponse.ReadOnly = new Wrapper(impl)
}
